/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.air;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.entity.projectile.FeatherSpike;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;

public class FeatherSpikesSpell
extends Spell {
    public static final String NAME = "feather_spikes";
    private final int castCount;

    public FeatherSpikesSpell(ResourceKey<Spell> key, int castCount) {
        super(key);
        this.castCount = castCount;
    }

    @Override
    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        if (caster instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)caster;
            this.addSpellInstance(new Instance(livingEntity));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private class Instance
    extends AbstractSpellInstance {
        private static final int INTERVAL = 10;
        private final LivingEntity livingEntity;
        private int remainingCasts;

        protected Instance(LivingEntity sender) {
            super((Entity)sender, FeatherSpikesSpell.this, FeatherSpikesSpell.this.castCount * 10);
            this.livingEntity = sender;
            this.remainingCasts = FeatherSpikesSpell.this.castCount;
        }

        @Override
        public void tick() {
            if (this.remainingCasts <= 0) {
                this.stop();
            } else if (this.getTicks() % 10 == 0) {
                Level level = this.livingEntity.f_19853_;
                FeatherSpike spike = new FeatherSpike(level, this.livingEntity);
                spike.m_37251_((Entity)this.livingEntity, this.livingEntity.m_146909_(), this.livingEntity.m_146908_(), 0.0f, 4.0f, 1.0f);
                level.m_7967_((Entity)spike);
                --this.remainingCasts;
            }
        }
    }
}

