/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell;

import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.spell.properties.SpellProperties;
import sirttas.elementalcraft.spell.tick.AbstractSpellInstance;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public class Spell
implements IElementTypeProvider {
    private String translationKey;
    protected final Holder<SpellProperties> properties;
    private final ResourceKey<Spell> key;

    protected Spell(ResourceKey<Spell> key) {
        this.properties = ElementalCraft.SPELL_PROPERTIES_MANAGER.getOrCreateHolder(SpellProperties.getKey(key));
        this.key = key;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"spell", (ResourceLocation)this.getKey());
        }
        return this.translationKey;
    }

    public ResourceLocation getKey() {
        return this.key.m_135782_();
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public Multimap<Attribute, AttributeModifier> getOnUseAttributeModifiers() {
        return this.getProperties().getAttributes();
    }

    @Nonnull
    public InteractionResult castOnEntity(@Nonnull Entity caster, @Nonnull Entity target) {
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResult castOnBlock(@Nonnull Entity caster, @Nonnull BlockPos target, @Nonnull BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    @Nonnull
    public InteractionResult castOnSelf(@Nonnull Entity caster) {
        return InteractionResult.PASS;
    }

    public void addSpellInstance(AbstractSpellInstance instance) {
        SpellTickHelper.get((ICapabilityProvider)instance.getCaster()).ifPresent(m -> m.addSpellInstance(instance));
    }

    public void delay(Entity caster, int delay, Runnable cast) {
        this.addSpellInstance(AbstractSpellInstance.delay(caster, this, delay, cast));
    }

    public void effect(Entity caster, int duration, Consumer<AbstractSpellInstance> tick) {
        this.addSpellInstance(AbstractSpellInstance.effect(caster, this, duration, tick));
    }

    public boolean consume(Entity caster, boolean simulate) {
        block3: {
            block2: {
                if (!(caster instanceof Player)) break block2;
                Player player = (Player)caster;
                if (player.m_150110_().f_35937_) break block3;
            }
            int consumeAmount = Math.max(1, Math.round((float)this.getConsumeAmount() * ToolInfusionHelper.getElementCostReduction(caster)));
            return ElementStorageHelper.get((ICapabilityProvider)caster).map(holder -> holder.extractElement(consumeAmount, this.getElementType(), simulate) >= consumeAmount).orElse(false);
        }
        return true;
    }

    protected boolean consume(Entity caster, ItemLike item, int count, boolean simulate) {
        if (caster instanceof Player) {
            Player player = (Player)caster;
            if (!player.m_150110_().f_35937_) {
                Inventory inv = player.m_150109_();
                int slot = ECContainerHelper.getSlotFor((Container)inv, new ItemStack(item));
                if (slot >= 0) {
                    ItemStack stack = inv.m_8020_(slot);
                    int size = Math.min(count, stack.m_41613_());
                    if (!simulate) {
                        stack.m_41774_(size);
                        if (stack.m_41619_()) {
                            inv.m_6836_(slot, ItemStack.f_41583_);
                        }
                    }
                    if (size < count) {
                        return this.consume(caster, item, count - size, simulate);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public int getCooldown() {
        return this.getProperties().cooldown();
    }

    public int getConsumeAmount() {
        return this.getProperties().consumeAmount();
    }

    @Override
    public ElementType getElementType() {
        return this.getProperties().getElementType();
    }

    public Type getSpellType() {
        return this.getProperties().spellType();
    }

    public int getUseDuration() {
        return this.getProperties().useDuration();
    }

    public int getWeight() {
        return this.getProperties().weight();
    }

    public float getRange(@Nullable Entity caster) {
        int bonus = 0;
        if (caster != null && StreamSupport.stream(caster.m_6167_().spliterator(), false).anyMatch(s -> !s.m_41619_() && s.m_150930_((Item)ECItems.STAFF.get()))) {
            ++bonus;
        }
        return this.getProperties().range() + (float)bonus;
    }

    public int getColor() {
        return this.getProperties().color();
    }

    private SpellProperties getProperties() {
        if (this.properties.m_203633_()) {
            return (SpellProperties)this.properties.m_203334_();
        }
        return SpellProperties.NONE;
    }

    public boolean isChannelable() {
        return this.getUseDuration() > 0;
    }

    public boolean isValid() {
        return this.getSpellType() != Type.NONE && this.getElementType() != ElementType.NONE;
    }

    public void addInformation(List<Component> tooltip) {
    }

    public String toString() {
        return this.key.toString();
    }

    public boolean isVisible() {
        return this.isValid() && !this.getProperties().hidden();
    }

    public UseAnim getUseAnimation() {
        return UseAnim.BOW;
    }

    public static enum Type implements StringRepresentable
    {
        NONE("none"),
        COMBAT("combat"),
        UTILITY("utility"),
        MIXED("mixed");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
        }
    }
}

