/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.particle;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.particle.element.ElementCraftingParticle;
import sirttas.elementalcraft.particle.element.ElementFlowParticle;
import sirttas.elementalcraft.particle.element.ElementTypeParticleData;
import sirttas.elementalcraft.particle.element.source.SourceParticle;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECParticles {
    private static final DeferredRegister<ParticleType<?>> DEFERRED_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"elementalcraft");
    public static final RegistryObject<ParticleType<ElementTypeParticleData>> SOURCE = ECParticles.register(() -> ElementTypeParticleData.createParticleType(true), "source");
    public static final RegistryObject<ParticleType<ElementTypeParticleData>> ELEMENT_FLOW = ECParticles.register(() -> ElementTypeParticleData.createParticleType(false), "element_flow");
    public static final RegistryObject<ParticleType<ElementTypeParticleData>> ELEMENT_CRAFTING = ECParticles.register(() -> ElementTypeParticleData.createParticleType(false), "elementcrafting");

    private ECParticles() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent evt) {
        evt.register((ParticleType)SOURCE.get(), SourceParticle.FACTORY);
        evt.register((ParticleType)ELEMENT_FLOW.get(), ElementFlowParticle.FACTORY);
        evt.register((ParticleType)ELEMENT_CRAFTING.get(), ElementCraftingParticle.FACTORY);
    }

    private static <O extends ParticleOptions, T extends ParticleType<O>> RegistryObject<T> register(Supplier<T> type, String name) {
        return DEFERRED_REGISTER.register(name, type);
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

