/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.jewel.effect;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.jewel.Jewel;

public class EffectJewel
extends Jewel {
    protected final List<MobEffectInstance> effects;

    public EffectJewel(ElementType elementType, int consumption, MobEffectInstance ... effects) {
        super(elementType, consumption);
        this.effects = ImmutableList.copyOf((Object[])effects);
    }

    public void apply(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (MobEffectInstance e : this.effects) {
                MobEffectInstance effect = new MobEffectInstance(e);
                effect.m_19562_(true);
                livingEntity.m_7292_(effect);
            }
        }
    }

    @Override
    public boolean isActive(@Nonnull Entity entity, @Nullable IElementStorage elementStorage) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Collection activeEffects = livingEntity.m_21220_();
            if (this.effects.stream().allMatch(e -> activeEffects.stream().anyMatch(a -> a.m_19544_().equals(e.m_19544_()) && a.m_19564_() >= e.m_19564_() && a.m_19557_() >= 2))) {
                return false;
            }
        }
        return super.isActive(entity, elementStorage);
    }
}

