/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.source.receptacle;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.source.trait.holder.SourceTraitHolderHelper;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.source.SourceBlock;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.source.trait.holder.SourceTraitHolder;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.property.ECProperties;

public class ReceptacleItem
extends ECItem {
    public static final String NAME = "receptacle";

    public ReceptacleItem() {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        CompoundTag blockEntityTag;
        CompoundTag tag;
        SourceTraitHolder holder = new SourceTraitHolder();
        if (holder.isEmpty() && (tag = stack.m_41783_()) != null && tag.m_128441_("BlockEntityTag") && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128441_("traits_holder")) {
            holder.deserializeNBT(blockEntityTag.m_128469_("traits_holder"));
        }
        return SourceTraitHolderHelper.createProvider(holder);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack sourceReceptacle = context.m_43722_();
        ElementType elementType = ReceptacleHelper.getElementType(sourceReceptacle);
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPlaceContext newContext = new BlockPlaceContext(context);
        BlockPos pos = newContext.m_8083_();
        if (newContext.m_7059_()) {
            level.m_46597_(pos, (BlockState)((SourceBlock)((Object)ECBlocks.SOURCE.get())).m_49966_().m_61124_(ElementType.STATE_PROPERTY, (Comparable)((Object)elementType)));
            BlockItem.m_40582_((Level)level, (Player)player, (BlockPos)pos, (ItemStack)sourceReceptacle);
            if (player != null && !player.m_150110_().f_35937_) {
                BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, SourceBlockEntity.class).ifPresent(SourceBlockEntity::exhaust);
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public String m_5671_(@Nonnull ItemStack stack) {
        return this.m_5524_() + "." + ReceptacleHelper.getElementType(stack).m_7912_();
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            for (ElementType elementType : ElementType.values()) {
                if (elementType == ElementType.NONE) continue;
                items.add((Object)ReceptacleHelper.create(elementType));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        boolean analyzed;
        CompoundTag blockEntityTag = stack.m_41737_("BlockEntityTag");
        if (blockEntityTag != null && (analyzed = blockEntityTag.m_128471_("analyzed"))) {
            blockEntityTag.m_128379_("analyzed", true);
            for (ISourceTraitValue value : this.getSourceTraitValues(stack)) {
                tooltip.add(value.getDescription());
            }
        }
    }

    @Nonnull
    private Collection<ISourceTraitValue> getSourceTraitValues(ItemStack stack) {
        return SourceTraitHolderHelper.get((ICapabilityProvider)stack).map(h -> h.getTraits().values()).orElse(Collections.emptyList());
    }
}

