/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.category.instrument.io;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import sirttas.elementalcraft.api.infusion.tool.ToolInfusion;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.instrument.infuser.IInfuser;
import sirttas.elementalcraft.infusion.tool.ToolInfusionHelper;
import sirttas.elementalcraft.interaction.jei.ECJEIRecipeTypes;
import sirttas.elementalcraft.interaction.jei.category.instrument.io.AbstractIOInstrumentRecipeCategory;
import sirttas.elementalcraft.interaction.jei.ingredient.ECIngredientTypes;
import sirttas.elementalcraft.recipe.instrument.infusion.IInfusionRecipe;
import sirttas.elementalcraft.recipe.instrument.infusion.ToolInfusionRecipe;

public class InfusionRecipeCategory
extends AbstractIOInstrumentRecipeCategory<IInfuser, IInfusionRecipe> {
    public InfusionRecipeCategory(IGuiHelper guiHelper) {
        this(guiHelper, "elementalcraft.jei.infusion");
    }

    protected InfusionRecipeCategory(IGuiHelper guiHelper, String translationKey) {
        super(guiHelper, translationKey, (ItemLike)ECBlocks.INFUSER.get());
    }

    @Nonnull
    public RecipeType<IInfusionRecipe> getRecipeType() {
        return ECJEIRecipeTypes.INFUSION;
    }

    @Override
    protected List<ItemStack> getTanks() {
        return List.of(this.container, new ItemStack((ItemLike)ECBlocks.SMALL_CONTAINER.get()));
    }

    @Override
    @Nonnull
    protected List<ItemStack> getOutputs(@Nonnull IInfusionRecipe recipe) {
        if (recipe instanceof ToolInfusionRecipe) {
            ToolInfusionRecipe toolInfusionRecipe = (ToolInfusionRecipe)recipe;
            ToolInfusion infusion = toolInfusionRecipe.getToolInfusion();
            return recipe.m_7527_().stream().flatMap(i -> Arrays.stream(i.m_43908_()).map(stack -> {
                ItemStack copy = stack.m_41777_();
                ToolInfusionHelper.setInfusion(copy, infusion);
                return copy;
            })).toList();
        }
        return super.getOutputs(recipe);
    }

    @Override
    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull IInfusionRecipe recipe, @Nonnull IFocusGroup focuses) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        List<ItemStack> output = this.getOutputs(recipe);
        IRecipeSlotBuilder inputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).addIngredients((Ingredient)ingredients.get(0));
        builder.addSlot(RecipeIngredientRole.CATALYST, 30, 24).addItemStack(this.instrument);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 30, 40).addItemStacks(this.getTanks());
        builder.addSlot(RecipeIngredientRole.INPUT, 30, 58).addIngredients(ECIngredientTypes.ELEMENT, this.getElementTypeIngredients(recipe));
        IRecipeSlotBuilder outputSlot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 59, 0).addItemStacks(output);
        if (recipe instanceof ToolInfusionRecipe && ((Ingredient)ingredients.get(0)).m_43908_().length == output.size()) {
            builder.createFocusLink(new IIngredientAcceptor[]{inputSlot, outputSlot});
        }
    }
}

