/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.solar;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECContainerBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.item.elemental.LensItem;
import sirttas.elementalcraft.particle.ParticleHelper;

public class SolarSynthesizerBlockEntity
extends AbstractECContainerBlockEntity
implements IContainerTopBlockEntity {
    private final SingleItemContainer inventory = new SingleItemContainer(this::m_6596_);
    private final RuneHandler runeHandler;
    protected boolean working;
    private ISingleElementStorage containerCache;

    public SolarSynthesizerBlockEntity(BlockPos pos, BlockState state) {
        this(ECBlockEntityTypes.SOLAR_SYNTHESIZER, pos, state);
    }

    protected SolarSynthesizerBlockEntity(RegistryObject<? extends BlockEntityType<?>> blockEntityType, BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)blockEntityType, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.solarSynthesizerMaxRunes.get(), this::m_6596_);
        this.working = false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SolarSynthesizerBlockEntity solarSynthesizer) {
        if (level.m_6042_().f_223549_() && level.m_45527_(pos) && level.m_46461_()) {
            int synthesized = solarSynthesizer.handleSynthesis(((Integer)ECConfig.COMMON.solarSynthesizerLensElementMultiplier.get()).intValue());
            if (synthesized > 0) {
                solarSynthesizer.breakLens(level, pos);
            }
        } else {
            solarSynthesizer.working = false;
        }
    }

    protected void breakLens(Level level, BlockPos pos) {
        ItemStack stack = this.inventory.m_8020_(0);
        if (!stack.m_41619_() && stack.m_41773_() >= stack.m_41776_()) {
            Vec3 position = Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, 0.40625, 0.0);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            level.m_6263_(null, position.m_7096_(), position.m_7098_(), position.m_7094_(), SoundEvents.f_12018_, SoundSource.BLOCKS, 0.8f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            ParticleHelper.createItemBreakParticle(level, position, level.f_46441_, stack, 3);
            this.m_6596_();
        }
    }

    protected int handleSynthesis(float amount) {
        ISingleElementStorage container = this.getContainer();
        if (container != null) {
            boolean hasSynthesized;
            int synthesized = this.getElementStorage().map(storage -> this.runeHandler.handleElementTransfer((ISingleElementStorage)storage, container, amount)).orElse(0);
            boolean bl = hasSynthesized = synthesized > 0;
            if (hasSynthesized || this.working) {
                this.working = hasSynthesized;
                this.m_6596_();
            }
            return synthesized;
        }
        return 0;
    }

    public boolean isWorking() {
        return this.working;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.m_128437_("rune_handler", 8));
        }
        this.working = compound.m_128471_("working");
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
        compound.m_128379_("working", this.working);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            if (cap == ElementalCraftCapabilities.ELEMENT_STORAGE) {
                return this.getElementStorage((Integer)ECConfig.COMMON.solarSynthesizerLensElementMultiplier.get());
            }
            if (cap == ElementalCraftCapabilities.RUNE_HANDLE) {
                return LazyOptional.of((NonNullSupplier)(this.runeHandler != null ? () -> this.runeHandler : null)).cast();
            }
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    protected <U> LazyOptional<U> getElementStorage(int multiplier) {
        ItemStack item = this.getInventory().m_8020_(0);
        Item item2 = item.m_41720_();
        if (item2 instanceof LensItem) {
            LensItem lens = (LensItem)item2;
            return LazyOptional.of(() -> lens.getStorage(item, multiplier)).cast();
        }
        return ElementStorageHelper.get((ICapabilityProvider)item).cast();
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }

    public Optional<ISingleElementStorage> getElementStorage() {
        return ElementStorageHelper.get((ICapabilityProvider)this).filter(ISingleElementStorage.class::isInstance).map(ISingleElementStorage.class::cast);
    }

    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }
}

