/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder.pedestal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.api.source.trait.holder.SourceTraitHolderHelper;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalElementStorage;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalItemContainer;
import sirttas.elementalcraft.block.source.trait.holder.SourceTraitHolder;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;

public class SourceBreederPedestalBlockEntity
extends AbstractIERBlockEntity
implements IElementTypeProvider {
    private final SourceBreederPedestalElementStorage elementStorage = new SourceBreederPedestalElementStorage(this);
    private final SingleItemContainer inventory = new SourceBreederPedestalItemContainer(this::m_6596_);
    private final RuneHandler runeHandler;

    public SourceBreederPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.SOURCE_BREEDER_PEDESTAL, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.COMMON.sourceBreederPedestalMaxRunes.get(), this::m_6596_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SourceBreederPedestalBlockEntity pedestal) {
        pedestal.elementStorage.refreshElement();
    }

    @Override
    @Nonnull
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    public IRuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Nullable
    public ISourceTraitHolder getTraitHolder() {
        return (ISourceTraitHolder)SourceTraitHolderHelper.get((ICapabilityProvider)this.getReceptacle()).orElseGet(SourceTraitHolder::new);
    }

    @Override
    public ElementType getElementType() {
        return ReceptacleHelper.getElementType(this.getReceptacle());
    }

    public ItemStack getReceptacle() {
        return this.inventory.m_8020_(0);
    }

    public boolean hasSource() {
        return !this.getReceptacle().m_41619_();
    }

    @Override
    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == ElementalCraftCapabilities.SOURCE_TRAIT_HOLDER) {
            return SourceTraitHolderHelper.get((ICapabilityProvider)this.getReceptacle()).cast();
        }
        return super.getCapability(cap, side);
    }
}

