/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.enderlock;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.enderlock.EnderLockHandler;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.entity.EntityHelper;

public class EnderLockShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = EnderLockShrineBlockEntity.createKey("enderlockshrine");
    protected static final List<Direction> UPGRADE_DIRECTIONS = List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST);

    public EnderLockShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.ENDER_LOCK_SHRINE, pos, state, PROPERTIES_KEY);
    }

    @Override
    public AABB getRangeBoundingBox() {
        float range = this.getRange();
        return new AABB(this.getTargetPos()).m_82377_((double)range, 0.0, (double)range).m_82363_(0.0, 2.0, 0.0);
    }

    public void onLoad() {
        EnderLockHandler.add(this);
    }

    @Override
    protected boolean doPeriod() {
        return false;
    }

    public boolean doLock(Entity entity) {
        int consumeAmount = this.getConsumeAmount();
        float rangeSq = this.getRange();
        rangeSq *= rangeSq;
        if ((!this.hasUpgrade(ShrineUpgrades.PROTECTION) || EntityHelper.isHostile(entity)) && entity.m_20318_(0.0f).m_82557_(Vec3.m_82512_((Vec3i)this.m_58899_())) <= (double)rangeSq && this.elementStorage.getElementAmount() >= consumeAmount) {
            this.consumeElement(consumeAmount);
            return true;
        }
        return false;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return UPGRADE_DIRECTIONS;
    }
}

