/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.breeding;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.breeding.BreedingShrineBlockEntity;

public class BreedingShrineBlock
extends AbstractShrineBlock<BreedingShrineBlockEntity> {
    public static final String NAME = "breedingshrine";
    private static final VoxelShape BASE_CORE = Shapes.m_83110_((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape)Block.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0));
    private static final VoxelShape CORE_NORTH_1 = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0);
    private static final VoxelShape CORE_NORTH_2 = Block.m_49796_((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    private static final VoxelShape CORE_SOUTH_1 = Block.m_49796_((double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape CORE_SOUTH_2 = Block.m_49796_((double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    private static final VoxelShape CORE_WEST_1 = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0);
    private static final VoxelShape CORE_WEST_2 = Block.m_49796_((double)0.0, (double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    private static final VoxelShape CORE_EAST_1 = Block.m_49796_((double)13.0, (double)3.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape CORE_EAST_2 = Block.m_49796_((double)11.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape CORE_NORTH = Shapes.m_83124_((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_NORTH_1, CORE_NORTH_2});
    private static final VoxelShape CORE_SOUTH = Shapes.m_83124_((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_SOUTH_1, CORE_SOUTH_2});
    private static final VoxelShape CORE_WEST = Shapes.m_83124_((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_WEST_1, CORE_WEST_2});
    private static final VoxelShape CORE_EAST = Shapes.m_83124_((VoxelShape)BASE_CORE, (VoxelShape[])new VoxelShape[]{CORE_EAST_1, CORE_EAST_2});
    private static final VoxelShape BASE_BOWL_FULL = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape BASE_BOWL_VOID = Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape BASE_BOWL = Shapes.m_83113_((VoxelShape)BASE_BOWL_FULL, (VoxelShape)BASE_BOWL_VOID, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape BOWL_NORTH_1 = Block.m_49796_((double)5.0, (double)7.0, (double)11.0, (double)11.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_NORTH_2 = Block.m_49796_((double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    private static final VoxelShape BOWL_NORTH_3 = Block.m_49796_((double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOWL_NORTH_TAPE = Block.m_49796_((double)7.0, (double)10.0, (double)8.0, (double)9.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_SOUTH_1 = Block.m_49796_((double)5.0, (double)7.0, (double)3.0, (double)11.0, (double)12.0, (double)5.0);
    private static final VoxelShape BOWL_SOUTH_2 = Block.m_49796_((double)5.0, (double)12.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    private static final VoxelShape BOWL_SOUTH_3 = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)12.0, (double)3.0);
    private static final VoxelShape BOWL_SOUTH_TAPE = Block.m_49796_((double)7.0, (double)10.0, (double)5.0, (double)9.0, (double)12.0, (double)8.0);
    private static final VoxelShape BOWL_WEST_1 = Block.m_49796_((double)11.0, (double)7.0, (double)5.0, (double)13.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_WEST_2 = Block.m_49796_((double)11.0, (double)12.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOWL_WEST_3 = Block.m_49796_((double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_WEST_TAPE = Block.m_49796_((double)8.0, (double)10.0, (double)7.0, (double)11.0, (double)12.0, (double)9.0);
    private static final VoxelShape BOWL_EAST_1 = Block.m_49796_((double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0);
    private static final VoxelShape BOWL_EAST_2 = Block.m_49796_((double)0.0, (double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    private static final VoxelShape BOWL_EAST_3 = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0);
    private static final VoxelShape BOWL_EAST_TAPE = Block.m_49796_((double)5.0, (double)10.0, (double)7.0, (double)8.0, (double)12.0, (double)9.0);
    private static final VoxelShape BOWL_NORTH = Shapes.m_83124_((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_NORTH_1, BOWL_NORTH_2, BOWL_NORTH_3, BOWL_NORTH_TAPE});
    private static final VoxelShape BOWL_SOUTH = Shapes.m_83124_((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_SOUTH_1, BOWL_SOUTH_2, BOWL_SOUTH_3, BOWL_SOUTH_TAPE});
    private static final VoxelShape BOWL_WEST = Shapes.m_83124_((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_WEST_1, BOWL_WEST_2, BOWL_WEST_3, BOWL_WEST_TAPE});
    private static final VoxelShape BOWL_EAST = Shapes.m_83124_((VoxelShape)BASE_BOWL, (VoxelShape[])new VoxelShape[]{BOWL_EAST_1, BOWL_EAST_2, BOWL_EAST_3, BOWL_EAST_TAPE});
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public BreedingShrineBlock() {
        super(ElementType.EARTH);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.CORE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.m_7731_(pos.m_121945_((Direction)state.m_61143_((Property)FACING)), (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.BOWL)), 3);
    }

    public void m_5707_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        Part part;
        BlockPos blockpos;
        BlockState blockstate;
        if (!level.f_46443_ && player.m_7500_() && (blockstate = level.m_8055_(blockpos = pos.m_121945_(BreedingShrineBlock.getNeighbourDirection(part = (Part)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)FACING))))).m_60734_() == this && blockstate.m_61143_(PART) != part) {
            level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    @Nonnull
    @Deprecated
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (facing == BreedingShrineBlock.getNeighbourDirection((Part)((Object)state.m_61143_(PART)), (Direction)state.m_61143_((Property)FACING))) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(PART) != state.m_61143_(PART) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    private static Direction getNeighbourDirection(Part part, Direction direction) {
        return part == Part.CORE ? direction : direction.m_122424_();
    }

    @Override
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        if (!context.m_43725_().m_8055_(context.m_8083_().m_121945_(facing)).m_60629_(context)) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{WATERLOGGED, FACING, PART});
    }

    @Override
    public BreedingShrineBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.m_61143_(PART) == Part.CORE ? (BreedingShrineBlockEntity)super.newBlockEntity(pos, state) : null;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (state.m_61143_(PART) == Part.CORE) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.NORTH -> CORE_NORTH;
                case Direction.SOUTH -> CORE_SOUTH;
                case Direction.WEST -> CORE_WEST;
                case Direction.EAST -> CORE_EAST;
                default -> BASE_CORE;
            };
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> BOWL_NORTH;
            case Direction.SOUTH -> BOWL_SOUTH;
            case Direction.WEST -> BOWL_WEST;
            case Direction.EAST -> BOWL_EAST;
            default -> BASE_BOWL;
        };
    }

    @Nonnull
    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public static enum Part implements StringRepresentable
    {
        CORE("core"),
        BOWL("bowl");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }
    }
}

