/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.valve;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeShapes;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeTypes;
import sirttas.elementalcraft.block.shape.ShapeHelper;

public class ElementValvePipeUpgrade
extends PipeUpgrade {
    public static final String NAME = "element_valve";
    private static final VoxelShape BASE_SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.5, (double)10.0, (double)6.5, (double)9.5, (double)10.5, (double)9.5), (VoxelShape)Block.m_49796_((double)6.5, (double)12.5, (double)6.5, (double)9.5, (double)13.0, (double)9.5));
    private static final Map<Direction, VoxelShape> OPEN_SHAPES = ShapeHelper.directionShapes(Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)ElementPipeShapes.SECTION_SHAPES.get(Direction.UP)));
    private static final Map<Direction, VoxelShape> CLOSE_SHAPES = ShapeHelper.directionShapes(Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)10.0, (double)9.0), Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.5, (double)10.5, (double)7.5, (double)8.5, (double)11.0, (double)8.5), Block.m_49796_((double)7.5, (double)12.0, (double)7.5, (double)8.5, (double)12.5, (double)8.5)}));

    public ElementValvePipeUpgrade(ElementPipeBlockEntity pipe, Direction direction) {
        super((PipeUpgradeType)PipeUpgradeTypes.ELEMENT_VALVE.get(), pipe, direction);
    }

    public boolean isOpen() {
        return this.getPipe().isPowered();
    }

    @Override
    public VoxelShape getShape() {
        return this.isOpen() ? OPEN_SHAPES.get(this.getDirection()) : CLOSE_SHAPES.get(this.getDirection());
    }

    @Override
    public boolean canTransfer(ElementType type, ConnectionType connection) {
        return this.isOpen();
    }

    @Override
    public boolean replaceSection() {
        return true;
    }

    @Override
    public boolean replaceExtraction() {
        return false;
    }

    @Override
    @Nonnull
    public RenderShape getRenderShape() {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

