/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.extractor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.extractor.ExtractorBlockEntity;
import sirttas.elementalcraft.particle.ParticleHelper;

public class ExtractorBlock
extends AbstractECEntityBlock {
    public static final String NAME = "extractor";
    private static final VoxelShape BASE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    private static final VoxelShape PILLAR = Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0);
    private static final VoxelShape TOP = Block.m_49796_((double)6.0, (double)13.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape PIPE_N = Block.m_49796_((double)7.0, (double)1.0, (double)3.0, (double)9.0, (double)3.0, (double)6.0);
    private static final VoxelShape PIPE_S = Block.m_49796_((double)7.0, (double)1.0, (double)10.0, (double)9.0, (double)3.0, (double)13.0);
    private static final VoxelShape PIPE_E = Block.m_49796_((double)10.0, (double)1.0, (double)7.0, (double)13.0, (double)3.0, (double)9.0);
    private static final VoxelShape PIPE_W = Block.m_49796_((double)3.0, (double)1.0, (double)7.0, (double)6.0, (double)3.0, (double)9.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{PILLAR, TOP, PIPE_N, PIPE_S, PIPE_E, PIPE_W});

    public ExtractorBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ExtractorBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return ExtractorBlock.createECServerTicker(level, type, ECBlockEntityTypes.EXTRACTOR, ExtractorBlockEntity::serverTick);
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader world, BlockPos pos) {
        return BlockEntityHelper.isValidContainer(state, world, pos.m_7495_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)world, pos, ExtractorBlockEntity.class).filter(ExtractorBlockEntity::canExtract).ifPresent(e -> ParticleHelper.createElementFlowParticle(e.getSourceElementType(), world, Vec3.m_82512_((Vec3i)pos), Direction.DOWN, 1.0f, rand));
    }
}

