/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.client.Client;
import tfar.dankstorage.client.NumberEditBox;
import tfar.dankstorage.client.button.SmallButton;
import tfar.dankstorage.client.button.TripleToggleButton;
import tfar.dankstorage.container.AbstractDankMenu;
import tfar.dankstorage.inventory.DankSlot;
import tfar.dankstorage.network.server.C2SButtonPacket;
import tfar.dankstorage.network.server.C2SMessageLockSlotPacket;
import tfar.dankstorage.network.server.C2SSetFrequencyPacket;
import tfar.dankstorage.utils.PickupMode;
import tfar.dankstorage.utils.Utils;
import tfar.dankstorage.world.DankInventory;

public class DankStorageScreen<T extends AbstractDankMenu>
extends AbstractContainerScreen<T> {
    static final ResourceLocation background1 = new ResourceLocation("dankstorage", "textures/container/gui/dank1.png");
    static final ResourceLocation background2 = new ResourceLocation("dankstorage", "textures/container/gui/dank2.png");
    static final ResourceLocation background3 = new ResourceLocation("dankstorage", "textures/container/gui/dank3.png");
    static final ResourceLocation background4 = new ResourceLocation("dankstorage", "textures/container/gui/dank4.png");
    static final ResourceLocation background5 = new ResourceLocation("dankstorage", "textures/container/gui/dank5.png");
    static final ResourceLocation background6 = new ResourceLocation("textures/gui/container/generic_54.png");
    static final ResourceLocation background7 = new ResourceLocation("dankstorage", "textures/container/gui/dank7.png");
    protected final boolean is7;
    final ResourceLocation background;
    private EditBox frequency;
    private static final MutableComponent SAVE_C = DankStorageScreen.buildSaveComponent();
    private static final MutableComponent PICKUP_C = DankStorageScreen.buildPickupComponent();
    private static final MutableComponent STORAGE_TXT = Utils.translatable("text.dankstorage.blacklisted_storage").m_130940_(ChatFormatting.DARK_RED);
    private static final MutableComponent USAGE_TXT = Utils.translatable("text.dankstorage.blacklisted_usage").m_130940_(ChatFormatting.DARK_RED);

    public DankStorageScreen(T container, Inventory playerinventory, Component component, ResourceLocation background) {
        super(container, playerinventory, component);
        this.background = background;
        this.f_97727_ = 114 + ((AbstractDankMenu)this.f_97732_).rows * 18;
        this.is7 = ((AbstractDankMenu)this.f_97732_).rows > 6;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t1(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background1);
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t2(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background2);
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t3(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background3);
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t4(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background4);
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t5(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background5);
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t6(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background6);
    }

    public static <T extends AbstractDankMenu> DankStorageScreen<T> t7(T container, Inventory playerinventory, Component component) {
        return new DankStorageScreen<T>(container, playerinventory, component, background7);
    }

    protected void m_7856_() {
        super.m_7856_();
        Button.OnTooltip sortTooltip = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Utils.translatable("text.dankstorage.sort_button"), x, y);
        this.m_142416_((GuiEventListener)new SmallButton(this.f_97735_ + 143, this.f_97736_ + 4, 26, 12, (Component)Utils.literal("Sort"), b -> C2SButtonPacket.send(C2SButtonPacket.Action.SORT), sortTooltip));
        Button.OnTooltip freqTooltip = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Utils.translatable("text.dankstorage." + (((AbstractDankMenu)this.f_97732_).dankInventory.frequencyLocked() ? "un" : "") + "lock_button"), x, y);
        Button.OnTooltip pickupTooltip = (button, poseStack, x, y) -> this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)PICKUP_C, Math.max(this.f_96543_ / 2 - 43, 170)), x, y);
        Button.OnTooltip compressTooltip = (button, poseStack, x, y) -> this.m_96602_(poseStack, (Component)Utils.translatable("text.dankstorage.compress_button"), x, y);
        Button.OnTooltip saveTooltip = (button, poseStack, x, y) -> this.m_96617_(poseStack, this.f_96541_.f_91062_.m_92923_((FormattedText)SAVE_C, Math.max(this.f_96543_ / 2 - 43, 170)), x, y);
        this.m_142416_((GuiEventListener)new TripleToggleButton(this.f_97735_ + 101, this.f_97736_ + 4, 12, 12, (Component)Utils.literal("P"), b -> C2SButtonPacket.send(C2SButtonPacket.Action.TOGGLE_PICKUP), pickupTooltip, this));
        this.m_142416_((GuiEventListener)new SmallButton(this.f_97735_ + 115, this.f_97736_ + 4, 12, 12, (Component)Utils.literal(""), button -> C2SButtonPacket.send(C2SButtonPacket.Action.LOCK_FREQUENCY), freqTooltip){

            public Component m_6035_() {
                return ((AbstractDankMenu)((DankStorageScreen)DankStorageScreen.this).f_97732_).dankInventory.frequencyLocked() ? Utils.literal("X").m_130940_(ChatFormatting.RED) : Utils.literal("O");
            }
        });
        this.m_142416_((GuiEventListener)new SmallButton(this.f_97735_ + 157, this.f_97736_ + this.f_97731_ - 2, 12, 12, (Component)Utils.literal("s"), b -> {
            try {
                if (((AbstractDankMenu)this.f_97732_).dankInventory.frequencyLocked()) {
                    return;
                }
                int id1 = Integer.parseInt(this.frequency.m_94155_());
                C2SSetFrequencyPacket.send(id1, true);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }, saveTooltip));
        this.m_142416_((GuiEventListener)new SmallButton(this.f_97735_ + 129, this.f_97736_ + 4, 12, 12, (Component)Utils.literal("C"), button -> C2SButtonPacket.send(C2SButtonPacket.Action.COMPRESS), compressTooltip));
        this.initEditbox();
    }

    protected void initEditbox() {
        this.f_96541_.f_91068_.m_90926_(true);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.frequency = new NumberEditBox(this.f_96547_, i + 92, j + this.f_97731_, 56, 12, (Component)Utils.translatable("dank"));
        this.frequency.m_94190_(true);
        this.frequency.m_94202_(-1);
        this.frequency.m_94205_(-1);
        this.frequency.m_94182_(false);
        this.frequency.m_94199_(10);
        this.frequency.m_94151_(this::onNameChanged);
        this.frequency.m_94144_("");
        this.frequency.m_94202_(-16711936);
        this.m_7787_((GuiEventListener)this.frequency);
        this.m_94718_((GuiEventListener)this.frequency);
        this.frequency.m_94178_(false);
    }

    private static MutableComponent buildSaveComponent() {
        return Utils.translatable("text.dankstorage.save_frequency_button", Utils.translatable("text.dankstorage.save_frequency_button.invalid", Utils.translatable("text.dankstorage.save_frequency_button.invalidtxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(DankInventory.TxtColor.INVALID.color)), Utils.translatable("text.dankstorage.save_frequency_button.too_high", Utils.translatable("text.dankstorage.save_frequency_button.too_hightxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(DankInventory.TxtColor.TOO_HIGH.color)), Utils.translatable("text.dankstorage.save_frequency_button.different_tier", Utils.translatable("text.dankstorage.save_frequency_button.different_tiertxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(DankInventory.TxtColor.DIFFERENT_TIER.color)), Utils.translatable("text.dankstorage.save_frequency_button.good", Utils.translatable("text.dankstorage.save_frequency_button.goodtxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(DankInventory.TxtColor.GOOD.color)), Utils.translatable("text.dankstorage.save_frequency_button.locked_frequency", Utils.translatable("text.dankstorage.save_frequency_button.locked_frequencytxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(DankInventory.TxtColor.LOCKED.color)));
    }

    private static MutableComponent buildPickupComponent() {
        return Utils.translatable("text.dankstorage.pickup_button", Utils.translatable("text.dankstorage.pickup_button.none", Utils.translatable("text.dankstorage.pickup_button.nonetxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(PickupMode.none.getColor())), Utils.translatable("text.dankstorage.pickup_button.all", Utils.translatable("text.dankstorage.pickup_button.alltxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(PickupMode.pickup_all.getColor())), Utils.translatable("text.dankstorage.pickup_button.filtered", Utils.translatable("text.dankstorage.pickup_button.filteredtxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(PickupMode.filtered_pickup.getColor())), Utils.translatable("text.dankstorage.pickup_button.void", Utils.translatable("text.dankstorage.pickup_button.voidtxt").m_130940_(ChatFormatting.GRAY)).m_130948_(Style.f_131099_.m_178520_(PickupMode.void_pickup.getColor())));
    }

    private void onNameChanged(String string) {
        try {
            int i = Integer.parseInt(string);
            C2SSetFrequencyPacket.send(i, false);
        }
        catch (NumberFormatException e) {
            C2SSetFrequencyPacket.send(-1, false);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean match;
        if (keyCode == 256 || Minecraft.m_91087_().f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            this.f_96541_.f_91074_.m_6915_();
        }
        if ((match = Client.LOCK_SLOT.m_90832_(keyCode, scanCode)) && this.f_97734_ instanceof DankSlot) {
            C2SMessageLockSlotPacket.send(this.f_97734_.f_40219_);
            return true;
        }
        if (!match && (this.frequency.m_7933_(keyCode, scanCode, modifiers) || this.frequency.m_94204_())) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_97799_(PoseStack pPoseStack, Slot pSlot) {
        super.m_97799_(pPoseStack, pSlot);
        int i = pSlot.f_40220_;
        int j = pSlot.f_40221_;
        if (!pSlot.m_6657_() && pSlot.f_40219_ < ((AbstractDankMenu)this.f_97732_).dankInventory.getSlots() && ((AbstractDankMenu)this.f_97732_).dankInventory.hasGhostItem(pSlot.f_40219_)) {
            this.f_96542_.m_115218_(((AbstractDankMenu)this.f_97732_).dankInventory.getGhostItem(pSlot.f_40219_), i, j);
            RenderSystem.m_69456_((int)516);
            GuiComponent.m_93172_((PoseStack)pPoseStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)0x40FFFFFF);
            RenderSystem.m_69456_((int)515);
        }
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.background);
        if (this.is7) {
            DankStorageScreen.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)256, (int)512);
        } else {
            this.m_93228_(stack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        }
        this.renderLockedSlots(stack);
    }

    protected void renderLockedSlots(PoseStack stack) {
        for (int i = 0; i < ((AbstractDankMenu)this.f_97732_).rows * 9; ++i) {
            int j = i % 9;
            int k = i / 9;
            int offsetx = 8;
            int offsety = 18;
            if (!((AbstractDankMenu)this.f_97732_).dankInventory.hasGhostItem(i)) continue;
            DankStorageScreen.m_93172_((PoseStack)stack, (int)(this.f_97735_ + j * 18 + offsetx), (int)(this.f_97736_ + k * 18 + offsety), (int)(this.f_97735_ + j * 18 + offsetx + 16), (int)(this.f_97736_ + k * 18 + offsety + 16), (int)-65536);
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        int color = ((AbstractDankMenu)this.f_97732_).dankInventory.getTextColor();
        this.frequency.m_94202_(color);
        this.frequency.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    public List<Component> m_96555_(ItemStack itemStack) {
        List tooltipFromItem = super.m_96555_(itemStack);
        this.appendDankInfo(tooltipFromItem, itemStack);
        return tooltipFromItem;
    }

    public void appendDankInfo(List<Component> tooltip, ItemStack stack) {
        if (stack.m_204117_(ModTags.BLACKLISTED_STORAGE)) {
            tooltip.add((Component)STORAGE_TXT);
        }
        if (stack.m_204117_(ModTags.BLACKLISTED_USAGE)) {
            tooltip.add((Component)USAGE_TXT);
        }
        if (this.f_97734_ instanceof DankSlot) {
            MutableComponent component1 = Utils.translatable("text.dankstorage.lock", Client.LOCK_SLOT.m_90863_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)component1);
            if (stack.m_41613_() >= 1000) {
                MutableComponent component2 = Utils.translatable("text.dankstorage.exact", Utils.literal(Integer.toString(stack.m_41613_())).m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.GRAY);
                tooltip.add((Component)component2);
            }
        }
    }

    protected void m_7027_(PoseStack poseStack, int i, int j) {
        RenderSystem.m_69461_();
        super.m_7027_(poseStack, i, j);
        int id = ((AbstractDankMenu)this.f_97732_).dankInventory.getFrequency();
        int color = 32768;
        this.f_96547_.m_92883_(poseStack, "ID: " + id, 62.0f, (float)this.f_97731_, color);
    }

    public void m_7861_() {
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
    }
}

