/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.blockentity.DockBlockEntity;
import tfar.dankstorage.item.DankItem;

public class DockBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty TIER = IntegerProperty.m_61631_((String)"tier", (int)0, (int)7);
    public static final VoxelShape EMPTY;
    public static final VoxelShape DOCKED;

    public DockBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)TIER) > 0 ? DOCKED : EMPTY;
    }

    @Nonnull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        BlockEntity tile;
        if (!world.f_46443_ && (tile = world.m_7702_(pos)) instanceof DockBlockEntity) {
            DockBlockEntity dockBlockEntity = (DockBlockEntity)tile;
            ItemStack held = player.m_21120_(hand);
            if (player.m_6047_() && held.m_204117_(ModTags.WRENCHES)) {
                world.m_46953_(pos, true, (Entity)player);
                return InteractionResult.SUCCESS;
            }
            if (held.m_41720_() instanceof DankItem) {
                if ((Integer)state.m_61143_((Property)TIER) > 0) {
                    dockBlockEntity.giveToPlayer(player);
                }
                dockBlockEntity.addDank(held);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6144_() && (Integer)state.m_61143_((Property)TIER) > 0) {
                dockBlockEntity.giveToPlayer(player);
                return InteractionResult.SUCCESS;
            }
            player.m_5893_((MenuProvider)tile);
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        ItemStack bag = ctx.m_43722_();
        Block block = Block.m_49814_((Item)bag.m_41720_());
        if (block instanceof DockBlock) {
            return block.m_49966_();
        }
        return block.m_5573_(ctx);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DockBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TIER});
    }

    static {
        VoxelShape a1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape b1 = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
        VoxelShape shape1 = Shapes.m_83148_((VoxelShape)a1, (VoxelShape)b1, (BooleanOp)BooleanOp.f_82687_);
        VoxelShape a2 = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape b2 = Block.m_49796_((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape shape2 = Shapes.m_83148_((VoxelShape)a2, (VoxelShape)b2, (BooleanOp)BooleanOp.f_82687_);
        VoxelShape p1 = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
        VoxelShape p2 = Block.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
        VoxelShape p3 = Block.m_49796_((double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0);
        VoxelShape p4 = Block.m_49796_((double)12.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
        EMPTY = Shapes.m_83124_((VoxelShape)shape1, (VoxelShape[])new VoxelShape[]{shape2, p1, p2, p3, p4});
        DOCKED = Shapes.m_83110_((VoxelShape)EMPTY, (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0));
    }
}

