/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import net.minecraft.world.item.enchantment.Enchantment;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;

public class MyTradeEnchantment {
    public String enchantmentKey;
    public Integer enchantmentLevel;
    public Integer maxEnchantmentLevel;

    public MyTradeEnchantment() {
        if (this.maxEnchantmentLevel == null) {
            this.maxEnchantmentLevel = 3;
        }
    }

    public MyTradeEnchantment(String key, int enchantmentLevel) {
        this();
        this.enchantmentKey = key;
        this.enchantmentLevel = enchantmentLevel;
    }

    public MyTradeEnchantment(String key, int enchantmentLevel, int maxEnchantmentLevel) {
        this(key, enchantmentLevel);
        this.maxEnchantmentLevel = maxEnchantmentLevel;
    }

    public Enchantment getEnchantment() {
        if (this.enchantmentKey.contains("#")) {
            String[] split = this.enchantmentKey.split("#");
            return TradeUtil.getEnchantmentFromKey(split[TradeUtil.random.nextInt(split.length)]);
        }
        return TradeUtil.getEnchantmentFromKey(this.enchantmentKey);
    }

    public boolean validate(String profession, int tradeEntry, String itemKey) {
        boolean isValid = true;
        if (this.enchantmentKey == null || this.enchantmentKey == "") {
            ModLogger.warn("Unable to add a custom trade! Reason: the enchantment key has not been defined - profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
            isValid = false;
        } else if (this.enchantmentKey.contains("#")) {
            for (String s : this.enchantmentKey.split("#")) {
                if (s.equalsIgnoreCase("none") || TradeUtil.checkEnchantmentKey(s)) continue;
                ModLogger.warn("Unable to add a custom trade! Reason: semi-random enchantment invalid - " + s + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
                isValid = false;
            }
        } else if (!this.enchantmentKey.equalsIgnoreCase("none") && !TradeUtil.checkEnchantmentKey(this.enchantmentKey)) {
            ModLogger.warn("Unable to add a custom trade! Reason: enchantment invalid - " + this.enchantmentKey + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
            isValid = false;
        }
        return isValid;
    }
}

