/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.mixin;

import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffers;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import uk.co.dotcode.customvillagertrades.ConfigHandler;
import uk.co.dotcode.customvillagertrades.TradeUtil;

@Mixin(value={Villager.class}, priority=9999)
public abstract class MixinVillagerTrades {
    @Invoker(value="getVillagerData")
    public abstract VillagerData invokeGetVillagerData();

    @Redirect(method={"updateTrades"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;addOffersFromItemListings(Lnet/minecraft/world/item/trading/MerchantOffers;[Lnet/minecraft/world/entity/npc/VillagerTrades$ItemListing;I)V"))
    private void redirectAddOffersFromItemListings(Villager villager, MerchantOffers merchantOffers, VillagerTrades.ItemListing[] itemListings, int i) {
        VillagerData data = this.invokeGetVillagerData();
        VillagerProfession profession = data.m_35571_();
        if (ConfigHandler.customTrades.get(TradeUtil.getKeyFromProfession(profession)) != null) {
            int maxTrades = ConfigHandler.customTrades.get((Object)TradeUtil.getKeyFromProfession((VillagerProfession)profession)).maxTrades;
            TradeUtil.addOffersFromItemListings((AbstractVillager)villager, itemListings, maxTrades);
        } else {
            TradeUtil.addOffersFromItemListings((AbstractVillager)villager, itemListings, 2);
        }
    }

    @ModifyVariable(method={"updateTrades()V"}, at=@At(value="STORE"), ordinal=0)
    private VillagerTrades.ItemListing[] injected(VillagerTrades.ItemListing[] originalEntries) {
        VillagerData data = this.invokeGetVillagerData();
        VillagerProfession profession = data.m_35571_();
        int level = data.m_35576_();
        if (ConfigHandler.registeredCustomTrades.containsKey(TradeUtil.getKeyFromProfession(profession))) {
            boolean shouldRemoveAll = ConfigHandler.customTrades.get((Object)TradeUtil.getKeyFromProfession((VillagerProfession)profession)).removeOtherTrades;
            Object[] customTrades = this.getApplicableTrades(profession, level);
            if (shouldRemoveAll) {
                return customTrades;
            }
            VillagerTrades.ItemListing[] mergedTrades = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])originalEntries, (Object[])customTrades);
            return mergedTrades;
        }
        return originalEntries;
    }

    private VillagerTrades.ItemListing[] getApplicableTrades(VillagerProfession profession, int level) {
        Object[] addedEntries;
        Object[] allCustomEntries = addedEntries = ConfigHandler.registeredCustomTrades.get(TradeUtil.getKeyFromProfession(profession)).get(level);
        if (ConfigHandler.registeredAllCategoryTrades != null && ConfigHandler.registeredAllCategoryTrades.containsKey(level)) {
            Object[] addedAllCategoryEntries = ConfigHandler.registeredAllCategoryTrades.get(level);
            allCustomEntries = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])addedEntries, (Object[])addedAllCategoryEntries);
        }
        return allCustomEntries;
    }
}

