/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.sound;

import com.mrh0.createaddition.sound.CAContinuousSound;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

class CASoundScape {
    List<CAContinuousSound> continuous;
    private final float pitch;
    private final CASoundScapes.AmbienceGroup group;
    private Vec3 meanPos;
    private final CASoundScapes.PitchGroup pitchGroup;

    public CASoundScape(float pitch, CASoundScapes.AmbienceGroup group) {
        this.pitchGroup = CASoundScapes.getGroupFromPitch(pitch);
        this.pitch = pitch;
        this.group = group;
        this.continuous = new ArrayList<CAContinuousSound>();
    }

    public CASoundScape continuous(SoundEvent sound, float relativeVolume, float relativePitch) {
        return this.add(new CAContinuousSound(sound, this, this.pitch * relativePitch, relativeVolume));
    }

    public CASoundScape add(CAContinuousSound continuousSound) {
        this.continuous.add(continuousSound);
        return this;
    }

    public void play() {
        this.continuous.forEach(arg_0 -> ((SoundManager)Minecraft.m_91087_().m_91106_()).m_120367_(arg_0));
    }

    public void tick() {
        if (AnimationTickHolder.getTicks() % 5 == 0) {
            this.meanPos = null;
        }
    }

    public void remove() {
        this.continuous.forEach(CAContinuousSound::remove);
    }

    public Vec3 getMeanPos() {
        return this.meanPos == null ? (this.meanPos = this.determineMeanPos()) : this.meanPos;
    }

    private Vec3 determineMeanPos() {
        this.meanPos = Vec3.f_82478_;
        int amount = 0;
        for (BlockPos blockPos : CASoundScapes.getAllLocations(this.group, this.pitchGroup)) {
            this.meanPos = this.meanPos.m_82549_(VecHelper.getCenterOf((Vec3i)blockPos));
            ++amount;
        }
        if (amount == 0) {
            return this.meanPos;
        }
        return this.meanPos.m_82490_((double)(1.0f / (float)amount));
    }

    public float getVolume() {
        Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
        float distanceMultiplier = 0.0f;
        if (renderViewEntity != null) {
            double distanceTo = renderViewEntity.m_20182_().m_82554_(this.getMeanPos());
            distanceMultiplier = (float)Mth.m_14139_((double)(distanceTo / 16.0), (double)2.0, (double)0.0);
        }
        int soundCount = CASoundScapes.getSoundCount(this.group, this.pitchGroup);
        float max = AllConfigs.client().ambientVolumeCap.getF();
        float argMax = 15.0f;
        return Mth.m_14036_((float)((float)soundCount / (argMax * 10.0f)), (float)0.025f, (float)max) * distanceMultiplier;
    }
}

