/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CarriageSounds {
    CarriageContraptionEntity entity;
    LerpedFloat distanceFactor;
    LerpedFloat speedFactor;
    LerpedFloat approachFactor;
    LerpedFloat seatCrossfade;
    LoopingSound minecartEsqueSound;
    LoopingSound sharedWheelSound;
    LoopingSound sharedWheelSoundSeated;
    LoopingSound sharedHonkSound;
    Couple<SoundEvent> bogeySounds;
    SoundEvent closestBogeySound;
    boolean arrived;
    int tick;
    int prevSharedTick;

    public CarriageSounds(CarriageContraptionEntity entity) {
        this.entity = entity;
        this.bogeySounds = entity.getCarriage().bogeys.map(bogey -> bogey != null && bogey.getStyle() != null ? bogey.getStyle().getSoundType() : AllSoundEvents.TRAIN2.getMainEvent());
        this.closestBogeySound = (SoundEvent)this.bogeySounds.getFirst();
        this.distanceFactor = LerpedFloat.linear();
        this.speedFactor = LerpedFloat.linear();
        this.approachFactor = LerpedFloat.linear();
        this.seatCrossfade = LerpedFloat.linear();
        this.arrived = true;
    }

    public void tick(Carriage.DimensionalCarriageEntity dce) {
        AllSoundEvents.SoundEntry continuousSound;
        double distance2;
        Minecraft mc = Minecraft.m_91087_();
        Entity camEntity = mc.f_91075_;
        if (camEntity == null) {
            return;
        }
        Vec3 leadingAnchor = dce.leadingAnchor();
        Vec3 trailingAnchor = dce.trailingAnchor();
        if (leadingAnchor == null || trailingAnchor == null) {
            return;
        }
        ++this.tick;
        Vec3 cam = camEntity.m_146892_();
        Vec3 contraptionMotion = this.entity.m_20182_().m_82546_(this.entity.getPrevPositionVec());
        Vec3 combinedMotion = contraptionMotion.m_82546_(camEntity.m_20184_());
        Train train = this.entity.getCarriage().train;
        if (this.arrived && contraptionMotion.m_82553_() > (double)0.01f) {
            this.arrived = false;
        }
        if (this.arrived && this.entity.carriageIndex == 0) {
            train.accumulatedSteamRelease /= 2.0f;
        }
        this.arrived |= this.entity.isStalled();
        if (this.entity.carriageIndex == 0) {
            train.accumulatedSteamRelease = (float)Math.min((double)train.accumulatedSteamRelease + Math.min(0.5, Math.abs(contraptionMotion.m_82553_() / 10.0)), 10.0);
        }
        Vec3 toBogey1 = leadingAnchor.m_82546_(cam);
        Vec3 toBogey2 = trailingAnchor.m_82546_(cam);
        Couple<CarriageBogey> bogeys = this.entity.getCarriage().bogeys;
        double distance1 = toBogey1.m_82553_();
        CarriageBogey relevantBogey = bogeys.get(distance1 > (distance2 = toBogey2.m_82553_()));
        if (relevantBogey == null) {
            relevantBogey = (CarriageBogey)bogeys.getFirst();
        }
        if (relevantBogey != null) {
            this.closestBogeySound = relevantBogey.getStyle().getSoundType();
        }
        Vec3 toCarriage = distance1 > distance2 ? toBogey2 : toBogey1;
        double distance = Math.min(distance1, distance2);
        Vec3 soundLocation = cam.m_82549_(toCarriage);
        double dot = toCarriage.m_82541_().m_82526_(combinedMotion.m_82541_());
        this.speedFactor.chase(contraptionMotion.m_82553_(), 0.25, LerpedFloat.Chaser.exp(0.05f));
        this.distanceFactor.chase(Mth.m_14085_((double)100.0, (double)0.0, (double)((distance - 3.0) / 64.0)), 0.25, LerpedFloat.Chaser.exp(50.0));
        this.approachFactor.chase(Mth.m_14085_((double)50.0, (double)200.0, (double)(0.5 * (dot + 1.0))), 0.25, LerpedFloat.Chaser.exp(10.0));
        this.seatCrossfade.chase(camEntity.m_20202_() instanceof CarriageContraptionEntity ? 1.0 : 0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.speedFactor.tickChaser();
        this.distanceFactor.tickChaser();
        this.approachFactor.tickChaser();
        this.seatCrossfade.tickChaser();
        this.minecartEsqueSound = this.playIfMissing(mc, this.minecartEsqueSound, AllSoundEvents.TRAIN.getMainEvent());
        this.sharedWheelSound = this.playIfMissing(mc, this.sharedWheelSound, this.closestBogeySound);
        this.sharedWheelSoundSeated = this.playIfMissing(mc, this.sharedWheelSoundSeated, AllSoundEvents.TRAIN3.getMainEvent());
        float volume = Math.min(Math.min(this.speedFactor.getValue(), this.distanceFactor.getValue() / 100.0f), this.approachFactor.getValue() / 300.0f + 0.0125f);
        if (this.entity.carriageIndex == 0) {
            float v = volume * (1.0f - this.seatCrossfade.getValue() * 0.35f) * 0.75f;
            if ((3 + this.tick) % 4 == 0) {
                AllSoundEvents.STEAM.playAt(this.entity.f_19853_, soundLocation, v * ((this.tick + 7) % 8 == 0 ? 0.75f : 0.45f), 1.17f, false);
            }
            if (this.tick % 16 == 0) {
                AllSoundEvents.STEAM.playAt(this.entity.f_19853_, soundLocation, v * 1.5f, 0.8f, false);
            }
        }
        if (!this.arrived && this.speedFactor.getValue() < 0.002f && train.accumulatedSteamRelease > 1.0f) {
            this.arrived = true;
            float releaseVolume = train.accumulatedSteamRelease / 10.0f;
            this.entity.f_19853_.m_7785_(soundLocation.f_82479_, soundLocation.f_82480_, soundLocation.f_82481_, SoundEvents.f_12031_, SoundSource.NEUTRAL, 0.25f * releaseVolume, 0.78f, false);
            this.entity.f_19853_.m_7785_(soundLocation.f_82479_, soundLocation.f_82480_, soundLocation.f_82481_, SoundEvents.f_12628_, SoundSource.NEUTRAL, 0.2f * releaseVolume, 1.5f, false);
            AllSoundEvents.STEAM.playAt(this.entity.f_19853_, soundLocation, 0.75f * releaseVolume, 0.5f, false);
        }
        float pitchModifier = (float)(this.entity.m_19879_() * 10 % 13) / 36.0f;
        volume = Math.min(volume, this.distanceFactor.getValue() / 800.0f);
        float pitch = Mth.m_14036_((float)(this.speedFactor.getValue() * 2.0f + 0.25f), (float)0.75f, (float)1.95f) - pitchModifier;
        this.minecartEsqueSound.setPitch(pitch * 1.5f);
        volume = Math.min(volume, this.distanceFactor.getValue() / 1000.0f);
        for (Carriage carriage : train.carriages) {
            CarriageContraptionEntity mainEntity;
            Carriage.DimensionalCarriageEntity mainDCE = carriage.getDimensionalIfPresent((ResourceKey<Level>)this.entity.f_19853_.m_46472_());
            if (mainDCE == null || (mainEntity = (CarriageContraptionEntity)((Object)mainDCE.entity.get())) == null) continue;
            if (mainEntity.sounds == null) {
                mainEntity.sounds = new CarriageSounds(mainEntity);
            }
            mainEntity.sounds.submitSharedSoundVolume(soundLocation, volume);
            if (carriage == this.entity.getCarriage()) break;
            this.finalizeSharedVolume(0.0f);
            return;
        }
        if (train.honkTicks == 0) {
            if (this.sharedHonkSound != null) {
                this.sharedHonkSound.stopSound();
                this.sharedHonkSound = null;
            }
            return;
        }
        --train.honkTicks;
        train.determineHonk(this.entity.f_19853_);
        if (train.lowHonk == null) {
            return;
        }
        boolean low = train.lowHonk;
        float honkPitch = (float)Math.pow(2.0, (double)train.honkPitch / 12.0);
        AllSoundEvents.SoundEntry endSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL_END : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW_END;
        AllSoundEvents.SoundEntry soundEntry = continuousSound = !low ? AllSoundEvents.WHISTLE_TRAIN_MANUAL : AllSoundEvents.WHISTLE_TRAIN_MANUAL_LOW;
        if (train.honkTicks == 5) {
            endSound.playAt((Level)mc.f_91073_, soundLocation, 1.0f, honkPitch, false);
        }
        if (train.honkTicks == 19) {
            endSound.playAt((Level)mc.f_91073_, soundLocation, 0.5f, honkPitch, false);
        }
        this.sharedHonkSound = this.playIfMissing(mc, this.sharedHonkSound, continuousSound.getMainEvent());
        this.sharedHonkSound.setLocation(soundLocation);
        float fadeout = Mth.m_14036_((float)((float)(3 - train.honkTicks) / 3.0f), (float)0.0f, (float)1.0f);
        float fadein = Mth.m_14036_((float)((float)(train.honkTicks - 17) / 3.0f), (float)0.0f, (float)1.0f);
        this.sharedHonkSound.setVolume(1.0f - fadeout - fadein);
        this.sharedHonkSound.setPitch(honkPitch);
    }

    private LoopingSound playIfMissing(Minecraft mc, LoopingSound loopingSound, SoundEvent sound) {
        if (loopingSound == null) {
            loopingSound = new LoopingSound(sound, SoundSource.NEUTRAL);
            mc.m_91106_().m_120367_((SoundInstance)loopingSound);
        }
        return loopingSound;
    }

    public void submitSharedSoundVolume(Vec3 location, float volume) {
        Minecraft mc = Minecraft.m_91087_();
        this.minecartEsqueSound = this.playIfMissing(mc, this.minecartEsqueSound, AllSoundEvents.TRAIN.getMainEvent());
        this.sharedWheelSound = this.playIfMissing(mc, this.sharedWheelSound, this.closestBogeySound);
        this.sharedWheelSoundSeated = this.playIfMissing(mc, this.sharedWheelSoundSeated, AllSoundEvents.TRAIN3.getMainEvent());
        boolean approach = true;
        if (this.tick != this.prevSharedTick) {
            this.prevSharedTick = this.tick;
            approach = false;
        } else if (this.sharedWheelSound.m_7769_() > volume) {
            return;
        }
        Vec3 currentLoc = new Vec3(this.minecartEsqueSound.m_7772_(), this.minecartEsqueSound.m_7780_(), this.minecartEsqueSound.m_7778_());
        Vec3 newLoc = approach ? currentLoc.m_82549_(location.m_82546_(currentLoc).m_82490_(0.125)) : location;
        this.minecartEsqueSound.setLocation(newLoc);
        this.sharedWheelSound.setLocation(newLoc);
        this.sharedWheelSoundSeated.setLocation(newLoc);
        this.finalizeSharedVolume(volume);
    }

    public void finalizeSharedVolume(float volume) {
        float crossfade = this.seatCrossfade.getValue();
        this.minecartEsqueSound.setVolume((1.0f - crossfade * 0.65f) * volume / 2.0f);
        volume = Math.min(volume, Math.max((this.speedFactor.getValue() - 0.25f) / 4.0f + 0.01f, 0.0f));
        this.sharedWheelSoundSeated.setVolume(volume * crossfade);
        this.sharedWheelSound.setVolume(volume * (1.0f - crossfade) * 1.5f);
    }

    public void stop() {
        if (this.minecartEsqueSound != null) {
            this.minecartEsqueSound.stopSound();
        }
        if (this.sharedWheelSound != null) {
            this.sharedWheelSound.stopSound();
        }
        if (this.sharedWheelSoundSeated != null) {
            this.sharedWheelSoundSeated.stopSound();
        }
        if (this.sharedHonkSound != null) {
            this.sharedHonkSound.stopSound();
        }
    }

    class LoopingSound
    extends AbstractTickableSoundInstance {
        protected LoopingSound(SoundEvent p_119606_, SoundSource p_119607_) {
            super(p_119606_, p_119607_, SoundInstance.m_235150_());
            this.f_119580_ = SoundInstance.Attenuation.LINEAR;
            this.f_119578_ = true;
            this.f_119579_ = 0;
            this.f_119573_ = 1.0E-4f;
        }

        public void m_7788_() {
        }

        public void setVolume(float volume) {
            this.f_119573_ = volume;
        }

        public float m_7769_() {
            return this.f_119573_;
        }

        public void setPitch(float pitch) {
            this.f_119574_ = pitch;
        }

        public float m_7783_() {
            return this.f_119574_;
        }

        public void setLocation(Vec3 location) {
            this.f_119575_ = location.f_82479_;
            this.f_119576_ = location.f_82480_;
            this.f_119577_ = location.f_82481_;
        }

        public void stopSound() {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this);
        }
    }
}

