/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridDecorator;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.api.impl.DefaultCraftingGrid;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IMCHandler {
    public static final Logger logger = LogManager.getLogger();

    public static void processInterMod(InterModProcessEvent event) {
        event.getIMCStream(it -> it.equals("RegisterProvider") || it.equals("RegisterProviderV2") || it.equals("RegisterProviderV3")).forEach(message -> {
            String validContainerPredicate;
            Predicate<AbstractContainerMenu> matchesContainerClass;
            final CompoundTag tagCompound = (CompoundTag)message.messageSupplier().get();
            final String senderModId = message.senderModId();
            String containerClassName = tagCompound.m_128461_("ContainerClass");
            Predicate<AbstractContainerMenu> containerPredicate = matchesContainerClass = it -> it.getClass().getName().equals(containerClassName);
            String validContainerPredicateLegacy = tagCompound.m_128461_("ContainerCallback");
            if (!validContainerPredicateLegacy.isEmpty()) {
                try {
                    Class<?> functionClass = Class.forName(validContainerPredicateLegacy);
                    if (!Function.class.isAssignableFrom(functionClass)) {
                        logger.error("{} sent a container callback that's not even a function", (Object)senderModId);
                        return;
                    }
                    Function function = (Function)functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    containerPredicate = t -> matchesContainerClass.test((AbstractContainerMenu)t) && (Boolean)function.apply(t) != false;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("{} sent an invalid container callback.", (Object)senderModId);
                }
            }
            if (!(validContainerPredicate = tagCompound.m_128461_("ValidContainerPredicate")).isEmpty()) {
                try {
                    Class<?> predicateClass = Class.forName(validContainerPredicate);
                    if (!Predicate.class.isAssignableFrom(predicateClass)) {
                        logger.error("{} sent an invalid ValidContainerPredicate - it must implement Predicate<Container>", (Object)senderModId);
                        return;
                    }
                    Predicate providedPredicate = (Predicate)predicateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    containerPredicate = it -> matchesContainerClass.test((AbstractContainerMenu)it) && providedPredicate.test(it);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("{} sent an invalid ValidContainerPredicate: {}", (Object)senderModId, (Object)e.getMessage());
                }
            }
            String getGridStartFunction = tagCompound.m_128461_("GetGridStartFunction");
            Function gridStartFunction = null;
            if (!getGridStartFunction.isEmpty()) {
                try {
                    Class<?> functionClass = Class.forName(getGridStartFunction);
                    if (!Function.class.isAssignableFrom(functionClass)) {
                        logger.error("{} sent an invalid GetGridStartFunction - it must implement Function<Container, Integer>", (Object)senderModId);
                        return;
                    }
                    gridStartFunction = (Function)functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    logger.error("{} sent an invalid GetGridStartFunction: {}", (Object)senderModId, (Object)e.getMessage());
                }
            }
            final Predicate<AbstractContainerMenu> effectiveContainerPredicate = containerPredicate;
            final Function effectiveGridStartFunction = gridStartFunction;
            CraftingTweaksAPI.registerCraftingGridProvider(new CraftingGridProvider(){

                @Override
                public String getModId() {
                    return senderModId;
                }

                @Override
                public boolean handles(AbstractContainerMenu menu) {
                    return effectiveContainerPredicate.test(menu);
                }

                @Override
                public void buildCraftingGrids(CraftingGridBuilder builder, AbstractContainerMenu menu) {
                    CompoundTag clearCompound;
                    CompoundTag balanceCompound;
                    CompoundTag rotateCompound;
                    CraftingGridDecorator grid;
                    int gridSlotNumber = IMCHandler.getIntOr(tagCompound, "GridSlotNumber", 1);
                    int gridSize = IMCHandler.getIntOr(tagCompound, "GridSize", 9);
                    if (effectiveGridStartFunction != null) {
                        grid = new DefaultCraftingGrid(new ResourceLocation(senderModId, "default"), gridSlotNumber, gridSize){

                            @Override
                            public int getGridStartSlot(Player player, AbstractContainerMenu menu) {
                                return (Integer)effectiveGridStartFunction.apply(menu);
                            }
                        };
                        builder.addCustomGrid((CraftingGrid)((Object)grid));
                    } else {
                        grid = builder.addGrid(gridSlotNumber, gridSize);
                    }
                    int buttonOffsetX = tagCompound.m_128441_("ButtonOffsetX") ? tagCompound.m_128451_("ButtonOffsetX") : -16;
                    int buttonOffsetY = tagCompound.m_128441_("ButtonOffsetY") ? tagCompound.m_128451_("ButtonOffsetY") : 16;
                    ButtonAlignment alignToGrid = ButtonAlignment.LEFT;
                    String alignToGridName = tagCompound.m_128461_("AlignToGrid");
                    switch (alignToGridName.toLowerCase()) {
                        case "north": 
                        case "up": {
                            alignToGrid = ButtonAlignment.TOP;
                            break;
                        }
                        case "south": 
                        case "down": {
                            alignToGrid = ButtonAlignment.BOTTOM;
                            break;
                        }
                        case "east": 
                        case "right": {
                            alignToGrid = ButtonAlignment.RIGHT;
                            break;
                        }
                        case "west": 
                        case "left": {
                            alignToGrid = ButtonAlignment.LEFT;
                        }
                    }
                    grid.setButtonAlignment(alignToGrid);
                    if (tagCompound.m_128471_("HideButtons")) {
                        grid.hideAllTweakButtons();
                    }
                    if (tagCompound.m_128471_("PhantomItems")) {
                        grid.usePhantomItems();
                    }
                    if (!IMCHandler.getBoolOr(rotateCompound = tagCompound.m_128469_("TweakRotate"), "Enabled", true)) {
                        grid.disableTweak(TweakType.Rotate);
                    }
                    if (!IMCHandler.getBoolOr(rotateCompound, "ShowButton", true)) {
                        grid.hideTweakButton(TweakType.Rotate);
                    }
                    if (rotateCompound.m_128441_("ButtonX") || rotateCompound.m_128441_("ButtonY")) {
                        grid.setButtonPosition(TweakType.Rotate, buttonOffsetX + IMCHandler.getIntOr(rotateCompound, "ButtonX", 0), buttonOffsetY + IMCHandler.getIntOr(rotateCompound, "ButtonY", 0));
                    }
                    if (!IMCHandler.getBoolOr(balanceCompound = tagCompound.m_128469_("TweakBalance"), "Enabled", true)) {
                        grid.disableTweak(TweakType.Balance);
                    }
                    if (!IMCHandler.getBoolOr(balanceCompound, "ShowButton", true)) {
                        grid.hideTweakButton(TweakType.Balance);
                    }
                    if (balanceCompound.m_128441_("ButtonX") || balanceCompound.m_128441_("ButtonY")) {
                        grid.setButtonPosition(TweakType.Balance, buttonOffsetX + IMCHandler.getIntOr(balanceCompound, "ButtonX", 0), buttonOffsetY + IMCHandler.getIntOr(balanceCompound, "ButtonY", 0));
                    }
                    if (!IMCHandler.getBoolOr(clearCompound = tagCompound.m_128469_("TweakClear"), "Enabled", true)) {
                        grid.disableTweak(TweakType.Clear);
                    }
                    if (!IMCHandler.getBoolOr(clearCompound, "ShowButton", true)) {
                        grid.hideTweakButton(TweakType.Clear);
                    }
                    if (clearCompound.m_128441_("ButtonX") || clearCompound.m_128441_("ButtonY")) {
                        grid.setButtonPosition(TweakType.Clear, buttonOffsetX + IMCHandler.getIntOr(clearCompound, "ButtonX", 0), buttonOffsetY + IMCHandler.getIntOr(clearCompound, "ButtonY", 0));
                    }
                }
            });
            logger.info("{} has registered {} for CraftingTweaks", (Object)senderModId, (Object)containerClassName);
        });
    }

    private static int getIntOr(CompoundTag tagCompound, String key, int defaultVal) {
        return tagCompound.m_128441_(key) ? tagCompound.m_128451_(key) : defaultVal;
    }

    private static boolean getBoolOr(CompoundTag tagCompound, String key, boolean defaultVal) {
        return tagCompound.m_128441_(key) ? tagCompound.m_128471_(key) : defaultVal;
    }
}

