/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.impl.CraftingGridBuilderImpl;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CraftingTweaksProviderManager {
    private static final List<CraftingGridProvider> craftingGridProviders = new ArrayList<CraftingGridProvider>();

    public static void registerProvider(CraftingGridProvider provider) {
        if (provider.getModId().equals("minecraft") || Balm.isModLoaded((String)provider.getModId())) {
            provider.onInitialize();
            craftingGridProviders.add(provider);
        }
    }

    public static List<CraftingGrid> getCraftingGrids(AbstractContainerMenu menu) {
        CraftingGridBuilderImpl builder = new CraftingGridBuilderImpl();
        for (CraftingGridProvider provider : craftingGridProviders) {
            if (!provider.handles(menu)) continue;
            builder.setActiveModId(provider.getModId());
            if (provider.requiresServerSide() && !CraftingTweaks.isServerSideInstalled) continue;
            provider.buildCraftingGrids(builder, menu);
        }
        return builder.getGrids();
    }

    public static Optional<CraftingGrid> getDefaultCraftingGrid(AbstractContainerMenu menu) {
        List<CraftingGrid> grids = CraftingTweaksProviderManager.getCraftingGrids(menu);
        if (grids.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(grids.stream().filter(it -> it.getId().m_135815_().equals("default")).findFirst().orElse(grids.get(0)));
    }

    public static Optional<CraftingGrid> getCraftingGrid(AbstractContainerMenu menu, ResourceLocation gridId) {
        return CraftingTweaksProviderManager.getCraftingGrids(menu).stream().filter(it -> gridId.equals((Object)it.getId())).findFirst();
    }
}

