/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class MilkJarBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider {
    protected static final int MILK_CAPACITY = 32000;
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);
    protected final FluidTank milkTank = new FluidTank(32000){

        public boolean canFill(Fluid fluid) {
            return fluid.m_6212_(Compat.getMilkFluid()) && super.canFill(fluid);
        }

        public void setChanged() {
            MilkJarBlockEntity.this.m_6596_();
            MilkJarBlockEntity.this.sync();
        }
    };

    public MilkJarBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends MilkJarBlockEntity>)((BlockEntityType)ModBlockEntities.milkJar.get()), pos, state);
    }

    protected MilkJarBlockEntity(BlockEntityType<? extends MilkJarBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("FluidTank", (Tag)this.milkTank.serialize());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.milkTank.deserialize(tag.m_128469_("FluidTank"));
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
    }

    public FluidTank getFluidTank() {
        return this.milkTank;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    private static class MilkJarItemProvider
    extends AbstractKitchenItemProvider {
        private final NonNullList<ItemStack> itemStacks = NonNullList.m_122779_();
        private final MilkJarBlockEntity milkJar;
        private int milkUsed;

        public MilkJarItemProvider(MilkJarBlockEntity milkJar) {
            this.milkJar = milkJar;
            this.itemStacks.addAll(CookingRegistry.getMilkItems());
        }

        @Override
        public void resetSimulation() {
            this.milkUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.milkUsed / 1000;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (this.milkJar.getFluidTank().getAmount() - this.milkUsed >= amount * 1000) {
                if (requireBucket && ((ItemStack)this.itemStacks.get(slot)).m_41720_() == Items.f_42455_ && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return ItemStack.f_41583_;
                }
                if (simulate) {
                    this.milkUsed += amount * 1000;
                } else {
                    this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), amount * 1000, false);
                }
                return ContainerUtils.copyStackWithSize((ItemStack)((ItemStack)this.itemStacks.get(slot)), (int)amount);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!Balm.getHooks().canItemsStack(itemStack, providedStack)) continue;
                this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
                break;
            }
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        public ItemStack getStackInSlot(int slot) {
            if (this.milkJar.getFluidTank().getAmount() - this.milkUsed < 1000) {
                return ItemStack.f_41583_;
            }
            return (ItemStack)this.itemStacks.get(slot);
        }

        @Override
        public int getCountInSlot(int slot) {
            return this.milkJar.getFluidTank().getAmount() / 1000;
        }
    }
}

