/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.ModSounds;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.IngredientPredicateWithCacheImpl;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FridgeBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox {
    private final DefaultContainer container = new DefaultContainer(27){

        public void m_6596_() {
            FridgeBlockEntity.this.isDirty = true;
            FridgeBlockEntity.this.m_6596_();
        }
    };
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((Container)this.container){
        private final ItemStack snowStack;
        private final ItemStack iceStack;
        {
            this.snowStack = new ItemStack((ItemLike)Items.f_42452_);
            this.iceStack = new ItemStack((ItemLike)Blocks.f_50126_);
        }

        @Nullable
        private SourceItem applyIceUnit(IngredientPredicate predicate, int maxAmount) {
            if (FridgeBlockEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.snowStack, 64)) {
                return new SourceItem(this, -1, ContainerUtils.copyStackWithSize((ItemStack)this.snowStack, (int)maxAmount));
            }
            if (FridgeBlockEntity.this.getBaseFridge().hasIceUpgrade && predicate.test(this.iceStack, 64)) {
                return new SourceItem(this, -1, ContainerUtils.copyStackWithSize((ItemStack)this.iceStack, (int)maxAmount));
            }
            return null;
        }

        @Override
        @Nullable
        public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeBlockEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).m_41619_() || CookingRegistry.isToolItem(it));
            }
            return super.findSource(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }

        @Override
        @Nullable
        public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
            SourceItem iceUnitResult = this.applyIceUnit(predicate, maxAmount);
            if (iceUnitResult != null) {
                return iceUnitResult;
            }
            IngredientPredicate modifiedPredicate = predicate;
            if (FridgeBlockEntity.this.getBaseFridge().hasPreservationUpgrade) {
                modifiedPredicate = IngredientPredicateWithCacheImpl.and(predicate, (it, count) -> count > 1 || !Balm.getHooks().getCraftingRemainingItem(it).m_41619_() || CookingRegistry.isToolItem(it));
            }
            return super.findSourceAndMarkAsUsed(modifiedPredicate, maxAmount, inventories, requireBucket, simulate);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
    private Component customName;
    private boolean isDirty;
    public boolean hasIceUpgrade;
    public boolean hasPreservationUpgrade;

    public FridgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.fridge.get(), pos, state);
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen((SoundEvent)ModSounds.fridgeOpen.get());
        this.doorAnimator.setSoundEventClose((SoundEvent)ModSounds.fridgeClose.get());
    }

    public boolean hasIceUpgrade() {
        return this.hasIceUpgrade;
    }

    public void setHasIceUpgrade(boolean hasIceUpgrade) {
        this.hasIceUpgrade = hasIceUpgrade;
        this.markDirtyAndUpdate();
    }

    public boolean hasPreservationUpgrade() {
        return this.hasPreservationUpgrade;
    }

    public void setHasPreservationUpgrade(boolean hasPreservationUpgrade) {
        this.hasPreservationUpgrade = hasPreservationUpgrade;
        this.markDirtyAndUpdate();
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FridgeBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean m_7531_(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.m_7531_(id, type);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.container.deserialize(tag.m_128469_("ItemHandler"));
        this.hasIceUpgrade = tag.m_128471_("HasIceUpgrade");
        this.hasPreservationUpgrade = tag.m_128471_("HasPreservationUpgrade");
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        if (tag.m_128425_("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.m_128471_("IsForcedOpen"));
        }
        if (tag.m_128425_("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.m_128445_("NumPlayersUsing"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ItemHandler", (Tag)this.container.serialize());
        tag.m_128379_("HasIceUpgrade", this.hasIceUpgrade);
        tag.m_128379_("HasPreservationUpgrade", this.hasPreservationUpgrade);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
        tag.m_128379_("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.m_128344_("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    @Nullable
    public FridgeBlockEntity findNeighbourFridge() {
        if (this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60734_() instanceof FridgeBlock) {
            return (FridgeBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        }
        if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_() instanceof FridgeBlock) {
            return (FridgeBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        }
        return null;
    }

    public FridgeBlockEntity getBaseFridge() {
        FridgeBlockEntity baseFridge;
        if (!this.m_58898_()) {
            return this;
        }
        if (this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_() instanceof FridgeBlock && (baseFridge = (FridgeBlockEntity)this.f_58857_.m_7702_(this.f_58858_.m_7495_())) != null) {
            return baseFridge;
        }
        return this;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Container getCombinedContainer() {
        FridgeBlockEntity baseFridge = this.getBaseFridge();
        FridgeBlockEntity neighbourFridge = baseFridge == this ? this.findNeighbourFridge() : this;
        if (neighbourFridge != null) {
            return new CombinedContainer(new Container[]{neighbourFridge.container, baseFridge.container});
        }
        return this.container;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 2, 2));
    }

    public void markDirtyAndUpdate() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.m_6596_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new FridgeMenu(i, playerInventory, this);
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.cookingforblockheads.fridge");
    }

    public Container getContainer() {
        return this.container;
    }
}

