/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.basics.option;

import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandUpgrade;

public class WandUpgrades<T extends IWandUpgrade> {
    protected final CompoundTag tag;
    protected final String key;
    protected final ArrayList<T> upgrades;
    protected final T dval;

    public WandUpgrades(CompoundTag tag, String key, T dval) {
        this.tag = tag;
        this.key = key;
        this.dval = dval;
        this.upgrades = new ArrayList();
        if (dval != null) {
            this.upgrades.add(0, dval);
        }
        this.deserialize();
    }

    protected void deserialize() {
        ListTag listnbt = this.tag.m_128437_(this.key, 8);
        boolean require_fix = false;
        for (int i = 0; i < listnbt.size(); ++i) {
            String str = listnbt.m_128778_(i);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(str));
            try {
                IWandUpgrade data = (IWandUpgrade)item;
                this.upgrades.add(data);
                continue;
            }
            catch (ClassCastException e) {
                ConstructionWand.LOGGER.warn("Invalid wand upgrade: " + str);
                require_fix = true;
            }
        }
        if (require_fix) {
            this.serialize();
        }
    }

    protected void serialize() {
        ListTag listnbt = new ListTag();
        for (IWandUpgrade item : this.upgrades) {
            if (item == this.dval) continue;
            listnbt.add((Object)StringTag.m_129297_((String)item.getRegistryName().toString()));
        }
        this.tag.m_128365_(this.key, (Tag)listnbt);
    }

    public boolean addUpgrade(T upgrade) {
        if (this.hasUpgrade(upgrade)) {
            return false;
        }
        this.upgrades.add(upgrade);
        this.serialize();
        return true;
    }

    public boolean hasUpgrade(T upgrade) {
        return this.upgrades.contains(upgrade);
    }

    public ArrayList<T> getUpgrades() {
        return this.upgrades;
    }
}

