/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.machine.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.machines.CompactMachines;
import dev.compactmods.machines.api.codec.CodecExtensions;
import dev.compactmods.machines.graph.IGraphEdge;
import dev.compactmods.machines.graph.IGraphNode;
import dev.compactmods.machines.machine.graph.CompactMachineNode;
import dev.compactmods.machines.machine.graph.MachineRoomEdge;
import dev.compactmods.machines.room.graph.CompactMachineRoomNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.Logger;

public class DimensionMachineGraph
extends SavedData {
    private final ResourceKey<Level> level;
    private final MutableValueGraph<IGraphNode, IGraphEdge> graph;
    private final Map<BlockPos, CompactMachineNode> machines;
    private final Map<ChunkPos, CompactMachineRoomNode> rooms;
    public static final String DATA_KEY = "machine_connections";
    private final Codec<List<CompactMachineConnectionInfo>> CONN_CODEC = CompactMachineConnectionInfo.CODEC.listOf().fieldOf("connections").codec();

    private DimensionMachineGraph(ResourceKey<Level> level) {
        this.level = level;
        this.graph = ValueGraphBuilder.directed().build();
        this.machines = new HashMap<BlockPos, CompactMachineNode>();
        this.rooms = new HashMap<ChunkPos, CompactMachineRoomNode>();
    }

    private DimensionMachineGraph(ResourceKey<Level> level, @Nonnull CompoundTag nbt) {
        this(level);
        if (nbt.m_128441_("graph")) {
            CompoundTag graphNbt = nbt.m_128469_("graph");
            List connectionData = (List)this.CONN_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)graphNbt).resultOrPartial(arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0)).orElseThrow();
            this.loadConnections(connectionData);
        }
    }

    private void loadConnections(List<CompactMachineConnectionInfo> connectionInfo) {
        for (CompactMachineConnectionInfo i : connectionInfo) {
            this.addRoom(i.roomChunk);
            for (BlockPos connectedMachine : i.machines()) {
                this.addMachine(connectedMachine);
                this.connectMachineToRoom(connectedMachine, i.roomChunk);
            }
        }
    }

    public static DimensionMachineGraph forDimension(ServerLevel dimension) {
        DimensionDataStorage dimStore = dimension.m_8895_();
        return (DimensionMachineGraph)dimStore.m_164861_(tag -> new DimensionMachineGraph((ResourceKey<Level>)dimension.m_46472_(), (CompoundTag)tag), () -> new DimensionMachineGraph((ResourceKey<Level>)dimension.m_46472_()), DATA_KEY);
    }

    private List<CompactMachineConnectionInfo> buildConnections() {
        ArrayList<CompactMachineConnectionInfo> result = new ArrayList<CompactMachineConnectionInfo>();
        this.rooms.forEach((chunk, node) -> {
            Collection<BlockPos> machines = this.getMachinesFor((ChunkPos)chunk);
            CompactMachineConnectionInfo roomInfo = new CompactMachineConnectionInfo((ChunkPos)chunk, machines);
            result.add(roomInfo);
        });
        return result;
    }

    public void addMachine(BlockPos machine) {
        if (this.machines.containsKey(machine)) {
            return;
        }
        CompactMachineNode node = new CompactMachineNode(this.level, machine);
        this.graph.addNode((Object)node);
        this.machines.put(machine, node);
        this.m_77762_();
    }

    public void addRoom(ChunkPos roomChunk) {
        if (this.rooms.containsKey(roomChunk)) {
            return;
        }
        CompactMachineRoomNode node = new CompactMachineRoomNode(roomChunk);
        this.graph.addNode((Object)node);
        this.rooms.put(roomChunk, node);
        this.m_77762_();
    }

    public void connectMachineToRoom(BlockPos machine, ChunkPos room) {
        if (!this.machines.containsKey(machine)) {
            this.addMachine(machine);
        }
        if (!this.rooms.containsKey(room)) {
            this.addRoom(room);
        }
        CompactMachineNode machineNode = this.machines.get(machine);
        CompactMachineRoomNode roomNode = this.rooms.get(room);
        this.graph.putEdgeValue((Object)machineNode, (Object)roomNode, (Object)new MachineRoomEdge());
        this.m_77762_();
    }

    public Collection<BlockPos> getMachinesFor(ChunkPos room) {
        if (!this.rooms.containsKey(room)) {
            return Collections.emptySet();
        }
        CompactMachineRoomNode node = this.rooms.get(room);
        Set inbound = this.graph.predecessors((Object)node);
        return inbound.stream().filter(CompactMachineNode.class::isInstance).map(CompactMachineNode.class::cast).map(CompactMachineNode::position).collect(Collectors.toSet());
    }

    public Optional<ChunkPos> getConnectedRoom(BlockPos machinePos) {
        if (!this.machines.containsKey(machinePos)) {
            return Optional.empty();
        }
        CompactMachineNode node = this.machines.get(machinePos);
        Set connected = this.graph.successors((Object)node);
        return connected.stream().filter(n -> n instanceof CompactMachineRoomNode).map(n -> (CompactMachineRoomNode)n).map(CompactMachineRoomNode::pos).findFirst();
    }

    public Stream<CompactMachineNode> getMachines() {
        return this.machines.values().stream();
    }

    public void disconnectAndUnregister(int machine) {
        if (!this.machines.containsKey(machine)) {
            return;
        }
        CompactMachineNode node = this.machines.get(machine);
        this.graph.removeNode((Object)node);
        this.machines.remove(machine);
    }

    public void removeRoom(ChunkPos room) {
        if (!this.rooms.containsKey(room)) {
            return;
        }
        this.graph.removeNode((Object)this.rooms.get(room));
        this.rooms.remove(room);
    }

    public void disconnect(BlockPos machine) {
        if (!this.machines.containsKey(machine)) {
            return;
        }
        CompactMachineNode node = this.machines.get(machine);
        this.graph.successors((Object)node).stream().filter(cn -> cn instanceof CompactMachineRoomNode).forEach(room -> this.graph.removeEdge((Object)node, room));
        this.m_77762_();
    }

    public Optional<CompactMachineNode> getMachineNode(BlockPos worldPosition) {
        return Optional.ofNullable(this.machines.get(worldPosition));
    }

    public Optional<CompactMachineRoomNode> getRoomNode(ChunkPos room) {
        return Optional.ofNullable(this.rooms.get(room));
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag nbt) {
        List<CompactMachineConnectionInfo> connData = this.buildConnections();
        this.CONN_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, connData).resultOrPartial(arg_0 -> ((Logger)CompactMachines.LOGGER).error(arg_0)).ifPresent(gNbt -> nbt.m_128365_("graph", gNbt));
        return nbt;
    }

    private static class CompactMachineConnectionInfo {
        private final ChunkPos roomChunk;
        private final List<BlockPos> connectedMachines;
        public static final Codec<CompactMachineConnectionInfo> CODEC = RecordCodecBuilder.create(i -> i.group((App)CodecExtensions.CHUNKPOS.fieldOf("room").forGetter(CompactMachineConnectionInfo::room), (App)BlockPos.f_121852_.listOf().fieldOf("machines").forGetter(CompactMachineConnectionInfo::machines)).apply((Applicative)i, CompactMachineConnectionInfo::new));

        public CompactMachineConnectionInfo(ChunkPos roomChunk, Collection<BlockPos> connections) {
            this.roomChunk = roomChunk;
            this.connectedMachines = ImmutableList.copyOf(connections);
        }

        public ChunkPos room() {
            return this.roomChunk;
        }

        public List<BlockPos> machines() {
            return this.connectedMachines;
        }
    }
}

