/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common.block;

import com.illusivesoulworks.comforts.common.ComfortsConfig;
import com.illusivesoulworks.comforts.common.block.entity.BaseComfortsBlockEntity;
import com.illusivesoulworks.comforts.mixin.AccessorPlayer;
import com.illusivesoulworks.comforts.platform.Services;
import com.mojang.datafixers.util.Either;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BaseComfortsBlock
extends BedBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final BedType type;

    public BaseComfortsBlock(BedType type, DyeColor colorIn, BlockBehaviour.Properties properties) {
        super(colorIn, properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_49440_, (Comparable)BedPart.FOOT)).m_61124_((Property)f_49441_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (state.m_61143_((Property)f_49440_) != BedPart.HEAD && !(state = level.m_8055_(pos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)))).m_60713_((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!BaseComfortsBlock.m_49488_((Level)level)) {
            level.m_7471_(pos, false);
            BlockPos blockpos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
            if (level.m_8055_(blockpos).m_60713_((Block)this)) {
                level.m_7471_(blockpos, false);
            }
            level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5.0f, true, Explosion.BlockInteraction.DESTROY);
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)f_49441_)).booleanValue()) {
            if (!this.kickVillagerOutOfBed(level, pos)) {
                player.m_5661_((Component)Component.m_237115_((String)("block.comforts." + this.type.name + ".occupied")), true);
            }
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BaseComfortsBlock.trySleep(serverPlayer, pos).ifLeft(result -> {
                if (result != null) {
                    Component text;
                    switch (result) {
                        case NOT_POSSIBLE_NOW: {
                            Component component;
                            if (this.type == BedType.HAMMOCK) {
                                String key = "block.comforts." + this.type.name + ".no_sleep";
                                if (((Boolean)ComfortsConfig.SERVER.nightHammocks.get()).booleanValue()) {
                                    key = key + ".2";
                                }
                                component = Component.m_237115_((String)key);
                                break;
                            }
                            component = Component.m_237115_((String)"block.minecraft.bed.no_sleep");
                            break;
                        }
                        case TOO_FAR_AWAY: {
                            Component component = Component.m_237115_((String)("block.comforts." + this.type.name + ".too_far_away"));
                            break;
                        }
                        default: {
                            Component component = text = result.m_36423_();
                        }
                    }
                    if (text != null) {
                        player.m_5661_(text, true);
                    }
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    public static Either<Player.BedSleepingProblem, Unit> trySleep(ServerPlayer player, BlockPos at) {
        Player.BedSleepingProblem ret = Services.SLEEP_EVENTS.getSleepResult((Player)player, at);
        if (ret != null) {
            return Either.left((Object)ret);
        }
        Direction direction = (Direction)player.f_19853_.m_8055_(at).m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        if (!player.m_5803_() && player.m_6084_()) {
            if (!player.f_19853_.m_6042_().f_63858_()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            if (!BaseComfortsBlock.bedInRange(player, at, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.TOO_FAR_AWAY);
            }
            if (BaseComfortsBlock.bedBlocked(player, at, direction)) {
                return Either.left((Object)Player.BedSleepingProblem.OBSTRUCTED);
            }
            if (Services.SLEEP_EVENTS.isAwakeTime((Player)player, at)) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!player.m_7500_()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3 vector3d = Vec3.m_82539_((Vec3i)at);
                List list = player.f_19853_.m_6443_(Monster.class, new AABB(vector3d.m_7096_() - 8.0, vector3d.m_7098_() - 5.0, vector3d.m_7094_() - 8.0, vector3d.m_7096_() + 8.0, vector3d.m_7098_() + 5.0, vector3d.m_7094_() + 8.0), monster -> monster.m_6935_((Player)player));
                if (!list.isEmpty()) {
                    return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            player.m_5802_(at);
            ((AccessorPlayer)player).setSleepCounter(0);
            player.m_36220_(Stats.f_12969_);
            CriteriaTriggers.f_10583_.m_222618_(player);
            ((ServerLevel)player.f_19853_).m_8878_();
            return Either.right((Object)Unit.INSTANCE);
        }
        return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
    }

    private static boolean bedInRange(ServerPlayer playerEntity, BlockPos blockPos, Direction direction) {
        if (direction == null) {
            return false;
        }
        return BaseComfortsBlock.isReachableBedBlock(playerEntity, blockPos) || BaseComfortsBlock.isReachableBedBlock(playerEntity, blockPos.m_121945_(direction.m_122424_()));
    }

    private static boolean isReachableBedBlock(ServerPlayer playerEntity, BlockPos blockPos) {
        Vec3 vector3d = Vec3.m_82539_((Vec3i)blockPos);
        return Math.abs(playerEntity.m_20185_() - vector3d.m_7096_()) <= 3.0 && Math.abs(playerEntity.m_20186_() - vector3d.m_7098_()) <= 2.0 && Math.abs(playerEntity.m_20189_() - vector3d.m_7094_()) <= 3.0;
    }

    private static boolean bedBlocked(ServerPlayer playerEntity, BlockPos blockPos, Direction direction) {
        BlockPos blockpos = blockPos.m_7494_();
        return BaseComfortsBlock.isAbnormalCube(playerEntity.f_19853_, blockpos) || BaseComfortsBlock.isAbnormalCube(playerEntity.f_19853_, blockpos.m_121945_(direction.m_122424_()));
    }

    private static boolean isAbnormalCube(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60828_((BlockGetter)world, pos);
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos blockPos) {
        List list = level.m_6443_(Villager.class, new AABB(blockPos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public void m_5707_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        BedPart bedpart;
        if (!level.f_46443_ && player.m_7500_() && (bedpart = (BedPart)state.m_61143_((Property)f_49440_)) == BedPart.FOOT && (blockstate = level.m_8055_(blockpos = pos.m_121945_(BaseComfortsBlock.getDirectionToOther(bedpart, (Direction)state.m_61143_((Property)f_54117_))))).m_60734_() == this && blockstate.m_61143_((Property)f_49440_) == BedPart.HEAD) {
            if (((Boolean)blockstate.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                level.m_7731_(blockpos, Blocks.f_49990_.m_49966_(), 35);
            } else {
                level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            }
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        level.m_5898_(player, 2001, pos, BaseComfortsBlock.m_49956_((BlockState)state));
        if (state.m_204336_(BlockTags.f_13088_)) {
            PiglinAi.m_34873_((Player)player, (boolean)false);
        }
    }

    @Nonnull
    public BlockState m_7417_(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState ifluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
        super.m_7926_(builder);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity livingEntity, @Nonnull ItemStack stack) {
        super.m_6402_(level, pos, state, livingEntity, stack);
        BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
        if (stack.m_41788_()) {
            level.m_141902_(blockPos, this.getBlockEntityType()).ifPresent(blockEntity -> blockEntity.setName(stack.m_41786_()));
        }
    }

    public abstract BlockEntityType<? extends BaseComfortsBlockEntity> getBlockEntityType();

    static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

