/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

class Expander {
    private final Level level;
    private final Direction down;
    private final Direction right;
    private TileMonitor origin;
    private int width;
    private int height;

    Expander(TileMonitor origin) {
        this.origin = origin;
        this.width = origin.getWidth();
        this.height = origin.getHeight();
        this.level = Objects.requireNonNull(origin.m_58904_(), "level cannot be null");
        this.down = origin.getDown();
        this.right = origin.getRight();
    }

    void expand() {
        int changedCount = 0;
        int changeLimit = ComputerCraft.monitorWidth * ComputerCraft.monitorHeight + 1;
        while (this.expandIn(true, false) || this.expandIn(true, true) || this.expandIn(false, false) || this.expandIn(false, true)) {
            if (++changedCount <= changeLimit) continue;
            ComputerCraft.log.error("Monitor has grown too much. This suggests there's an empty monitor in the world.");
            break;
        }
        if (changedCount > 0) {
            this.origin.resize(this.width, this.height);
        }
    }

    private boolean expandIn(boolean useXAxis, boolean isPositive) {
        TileMonitor otherMonitor;
        BlockPos pos = this.origin.m_58899_();
        int height = this.height;
        int width = this.width;
        int otherOffset = isPositive ? (useXAxis ? width : height) : -1;
        BlockPos otherPos = useXAxis ? pos.m_5484_(this.right, otherOffset) : pos.m_5484_(this.down, otherOffset);
        BlockEntity other = this.level.m_7702_(otherPos);
        if (!(other instanceof TileMonitor) || !this.origin.isCompatible(otherMonitor = (TileMonitor)other)) {
            return false;
        }
        if (useXAxis) {
            if (otherMonitor.getYIndex() != 0 || otherMonitor.getHeight() != height) {
                return false;
            }
            if ((width += otherMonitor.getWidth()) > ComputerCraft.monitorWidth) {
                return false;
            }
        } else {
            if (otherMonitor.getXIndex() != 0 || otherMonitor.getWidth() != width) {
                return false;
            }
            if ((height += otherMonitor.getHeight()) > ComputerCraft.monitorHeight) {
                return false;
            }
        }
        if (!isPositive) {
            TileMonitor originMonitor;
            BlockEntity otherOrigin = this.level.m_7702_(otherMonitor.toWorldPos(0, 0));
            if (!(otherOrigin instanceof TileMonitor) || !this.origin.isCompatible(originMonitor = (TileMonitor)otherOrigin)) {
                return false;
            }
            this.origin = originMonitor;
        }
        this.width = width;
        this.height = height;
        return true;
    }
}

