/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import dan200.computercraft.shared.computer.core.ServerComputer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;

public class ServerComputerRegistry {
    private static final Random RANDOM = new Random();
    private final int sessionId = RANDOM.nextInt();
    private final Int2ObjectMap<ServerComputer> computers = new Int2ObjectOpenHashMap();
    private int nextInstanceId;

    public int getSessionID() {
        return this.sessionId;
    }

    int getUnusedInstanceID() {
        return this.nextInstanceId++;
    }

    @Nullable
    public ServerComputer get(int instanceID) {
        return instanceID >= 0 ? (ServerComputer)this.computers.get(instanceID) : null;
    }

    @Nullable
    public ServerComputer get(int sessionId, int instanceId) {
        return sessionId == this.sessionId ? this.get(instanceId) : null;
    }

    void update() {
        Iterator<ServerComputer> it = this.getComputers().iterator();
        while (it.hasNext()) {
            ServerComputer computer = it.next();
            if (computer.hasTimedOut()) {
                computer.unload();
                computer.onRemoved();
                it.remove();
                continue;
            }
            computer.tickServer();
        }
    }

    void add(int instanceID, ServerComputer computer) {
        this.remove(instanceID);
        this.computers.put(instanceID, (Object)computer);
        this.nextInstanceId = Math.max(this.nextInstanceId, instanceID + 1);
    }

    void remove(int instanceID) {
        ServerComputer computer = this.get(instanceID);
        if (computer != null) {
            computer.unload();
            computer.onRemoved();
        }
        this.computers.remove(instanceID);
    }

    void close() {
        for (ServerComputer computer : this.getComputers()) {
            computer.unload();
        }
        this.computers.clear();
    }

    public Collection<ServerComputer> getComputers() {
        return this.computers.values();
    }
}

