/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.IMount;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.annotation.Nonnull;

public class SubMount
implements IMount {
    private final IMount parent;
    private final String subPath;

    public SubMount(IMount parent, String subPath) {
        this.parent = parent;
        this.subPath = subPath;
    }

    @Override
    public boolean exists(@Nonnull String path) throws IOException {
        return this.parent.exists(this.getFullPath(path));
    }

    @Override
    public boolean isDirectory(@Nonnull String path) throws IOException {
        return this.parent.isDirectory(this.getFullPath(path));
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        this.parent.list(this.getFullPath(path), contents);
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        return this.parent.getSize(this.getFullPath(path));
    }

    @Override
    @Nonnull
    public ReadableByteChannel openForRead(@Nonnull String path) throws IOException {
        return this.parent.openForRead(this.getFullPath(path));
    }

    @Override
    @Nonnull
    public BasicFileAttributes getAttributes(@Nonnull String path) throws IOException {
        return this.parent.getAttributes(this.getFullPath(path));
    }

    private String getFullPath(String path) {
        return path.isEmpty() ? this.subPath : this.subPath + "/" + path;
    }
}

