/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.compiler;

import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.compiler.CompileException;
import cc.tweaked.internal.cobalt.compiler.FuncState;
import cc.tweaked.internal.cobalt.compiler.LoadState;
import cc.tweaked.internal.cobalt.compiler.Parser;
import cc.tweaked.internal.cobalt.function.LuaClosure;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import cc.tweaked.internal.cobalt.function.LuaInterpretedFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class LuaC
implements LoadState.LuaCompiler {
    public static final LuaC INSTANCE = new LuaC();
    public static final int MAXSTACK = 250;
    public static final int LUAI_MAXUPVALUES = 60;
    public static final int LUAI_MAXVARS = 200;

    protected static void _assert(boolean b) throws CompileException {
        if (!b) {
            throw new CompileException("compiler assert failed");
        }
    }

    public static int SET_OPCODE(int i, int o) {
        return i & 0xFFFFFFC0 | o << 0 & 0x3F;
    }

    public static int SETARG_A(int i, int u) {
        return i & 0xFFFFC03F | u << 6 & 0x3FC0;
    }

    public static int SETARG_B(int i, int u) {
        return i & 0x7FFFFF | u << 23 & 0xFF800000;
    }

    public static int SETARG_C(int i, int u) {
        return i & 0xFF803FFF | u << 14 & 0x7FC000;
    }

    public static int SETARG_Bx(int i, int u) {
        return i & 0x3FFF | u << 14 & 0xFFFFC000;
    }

    public static int SETARG_sBx(int i, int u) {
        return LuaC.SETARG_Bx(i, u + 131071);
    }

    public static int CREATE_ABC(int o, int a, int b, int c) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | b << 23 & 0xFF800000 | c << 14 & 0x7FC000;
    }

    public static int CREATE_ABx(int o, int a, int bc) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | bc << 14 & 0xFFFFC000;
    }

    public static int[] realloc(int[] v, int n) {
        int[] a = new int[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    public static byte[] realloc(byte[] v, int n) {
        byte[] a = new byte[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    private LuaC() {
    }

    @Override
    public LuaClosure load(InputStream stream, LuaString name, LuaString mode, LuaTable env) throws IOException, CompileException {
        Prototype p = LuaC.compile(stream, name, mode);
        LuaInterpretedFunction closure = new LuaInterpretedFunction(p, env);
        closure.nilUpvalues();
        return closure;
    }

    public static Prototype compile(InputStream stream, String name) throws IOException, CompileException {
        return LuaC.compile(stream, ValueFactory.valueOf(name));
    }

    public static Prototype compile(InputStream stream, LuaString name) throws IOException, CompileException {
        return LuaC.compile(stream, name, null);
    }

    public static Prototype compile(InputStream stream, LuaString name, LuaString mode) throws IOException, CompileException {
        int firstByte = stream.read();
        if (firstByte == 27) {
            LoadState.checkMode(mode, "binary");
            return LoadState.loadBinaryChunk(firstByte, stream, name);
        }
        LoadState.checkMode(mode, "text");
        try {
            return LuaC.luaY_parser(firstByte, stream, name);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static Prototype luaY_parser(int firstByte, InputStream z, LuaString name) throws CompileException {
        Parser lexstate = new Parser(z, firstByte, name);
        FuncState funcstate = lexstate.openFunc();
        funcstate.varargFlags = 2;
        lexstate.lexer.nextToken();
        lexstate.chunk();
        lexstate.check(284);
        Prototype prototype = lexstate.closeFunc();
        LuaC._assert(funcstate.upvalues.size() == 0);
        LuaC._assert(lexstate.fs == null);
        return prototype;
    }

    public LuaFunction load(Prototype p, LuaTable env) {
        return new LuaInterpretedFunction(p, env);
    }
}

