/*
 * Decompiled with CFR 0.152.
 */
package com.song.castle_in_the_sky.events;

import com.song.castle_in_the_sky.blocks.block_entities.LaputaCoreBE;
import com.song.castle_in_the_sky.config.ConfigCommon;
import com.song.castle_in_the_sky.effects.EffectRegister;
import com.song.castle_in_the_sky.items.ItemsRegister;
import com.song.castle_in_the_sky.items.LevitationStone;
import com.song.castle_in_the_sky.network.Channel;
import com.song.castle_in_the_sky.network.ClientHandlerClass;
import com.song.castle_in_the_sky.network.ServerToClientInfoPacket;
import com.song.castle_in_the_sky.utils.CapabilityCastle;
import com.song.castle_in_the_sky.utils.MyTradingRecipe;
import com.song.castle_in_the_sky.utils.RandomTradeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerEvents {
    private static final Set<String> DESTRUCTION_INCANTATIONS = new HashSet<String>(Arrays.asList("BARUSU", "BALSE", "BALUS", "\u30d0\u30eb\u30b9", "\u5df4\u9c81\u65af"));
    private static final int SEARCH_RADIUS = 5;
    private static final int SEARCH_RADIUS2 = 25;
    private static final int SEARCH_HEIGHT = 3;

    @SubscribeEvent
    public void onPlayerChat(ServerChatEvent.Submitted event) {
        if (DESTRUCTION_INCANTATIONS.contains(event.getMessage().getString())) {
            if (((Boolean)ConfigCommon.DISABLE_INCANTATION.get()).booleanValue()) {
                event.getPlayer().m_213846_((Component)Component.m_237115_((String)"info.castle_in_the_sky.destruction_disabled").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
                return;
            }
            ServerPlayer player = event.getPlayer();
            player.f_8924_.m_201446_(() -> ServerEvents.incantationSpoken(player, event));
        }
    }

    private static void incantationSpoken(ServerPlayer player, ServerChatEvent.Submitted event) {
        boolean found = false;
        AtomicBoolean warned = new AtomicBoolean(false);
        player.getCapability(CapabilityCastle.CASTLE_CAPS).ifPresent(data -> warned.set(data.isIncantationWarned()));
        if (player.m_21205_().m_41720_() instanceof LevitationStone) {
            for (int dy = -3; !found && dy <= 3; ++dy) {
                for (int dx = -5; !found && dx < 5; ++dx) {
                    for (int dz = -5; !found && dz < 5; ++dz) {
                        if (dx * dx + dz * dz >= 25) continue;
                        BlockEntity blockEntity = player.f_19853_.m_7702_(player.m_20183_().m_7918_(dx, dy, dz));
                        if (blockEntity != null) {
                            System.out.println("checkpoint");
                        }
                        if (!(blockEntity instanceof LaputaCoreBE) || ((LaputaCoreBE)blockEntity).isActive()) continue;
                        if (!warned.get()) {
                            player.m_213846_((Component)Component.m_237115_((String)"info.castle_in_the_sky.destruction_warning").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                            player.getCapability(CapabilityCastle.CASTLE_CAPS).ifPresent(data -> {
                                data.setIncantationWarned(true);
                                data.setWarningCD();
                            });
                            if (((Boolean)ConfigCommon.SILENT_INCANTATION.get()).booleanValue()) {
                                event.setCanceled(true);
                            }
                            return;
                        }
                        player.m_150109_().m_36057_(player.m_21205_());
                        ((LaputaCoreBE)blockEntity).setDestroying(true);
                        ((LaputaCoreBE)blockEntity).setActivatedInitPos(player.m_146892_());
                        player.getCapability(CapabilityCastle.CASTLE_CAPS).ifPresent(data -> data.setIncantationWarned(false));
                        found = true;
                        for (ServerPlayer playerOther : ((ServerLevel)player.f_19853_).m_6907_()) {
                            playerOther.m_213846_((Component)Component.m_237110_((String)"info.castle_in_the_sky.incantation_casted", (Object[])new Object[]{player.m_7755_()}).m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
                        }
                    }
                }
            }
            if (!found) {
                player.m_213846_((Component)Component.m_237115_((String)"info.castle_in_the_sky.crystal_not_found").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
            }
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"info.castle_in_the_sky.item_not_hold").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.BOLD}));
        }
        if (((Boolean)ConfigCommon.SILENT_INCANTATION.get()).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void tickCap(TickEvent.PlayerTickEvent event) {
        if (!event.player.f_19853_.m_5776_()) {
            event.player.getCapability(CapabilityCastle.CASTLE_CAPS).ifPresent(CapabilityCastle.Data::tick);
        }
    }

    @SubscribeEvent
    public void onAttachCapEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("castle_in_the_sky", "castle_caps"), (ICapabilityProvider)new CapabilityCastle());
        }
    }

    @SubscribeEvent
    public void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(CapabilityCastle.class);
    }

    @SubscribeEvent
    public void onVillageTradeRegister(VillagerTradesEvent event) {
        for (MyTradingRecipe recipe : ConfigCommon.MY_TRADING_RECIPES) {
            if (recipe.getItem1() == null && recipe.getItem2() == null || !Objects.requireNonNull(event.getType().toString()).equals(recipe.getStringProfession())) continue;
            int level = recipe.getLevel();
            List tmp = (List)event.getTrades().get(level);
            ArrayList<VillagerTrades.ItemListing> mutableTrades = new ArrayList<VillagerTrades.ItemListing>(tmp);
            mutableTrades.add(new RandomTradeBuilder(64, 25, 0.05f).setPrice(recipe.getItem1(), (Integer)recipe.price1Min().get(), (Integer)recipe.price1Max().get()).setPrice2(recipe.getItem2(), (Integer)recipe.price2Min().get(), (Integer)recipe.price2Max().get()).setForSale(recipe.getOutput(), (Integer)recipe.outputMin().get(), (Integer)recipe.outputMax().get()).build());
            event.getTrades().put(level, mutableTrades);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        Player playerEntity = event.getEntity();
        if (playerEntity.m_21023_((MobEffect)EffectRegister.SACRED_CASTLE_EFFECT.get()) && !playerEntity.m_7500_()) {
            event.setCanceled(true);
            if (playerEntity.f_19853_.m_5776_()) {
                ClientHandlerClass.showSacredCastleInfoBreak();
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player && ((Player)entity).m_21023_((MobEffect)EffectRegister.SACRED_CASTLE_EFFECT.get()) && !((Player)entity).m_7500_()) {
            event.setCanceled(true);
            if (entity instanceof ServerPlayer) {
                Channel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new ServerToClientInfoPacket((Component)Component.m_237115_((String)String.format("info.%s.sacred_castle_effect.place", "castle_in_the_sky")).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD)));
            }
        }
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        Entity killer;
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof EntityDamageSource && (killer = damageSource.m_7639_()) instanceof LivingEntity && ((LivingEntity)killer).m_21023_((MobEffect)EffectRegister.SACRED_CASTLE_EFFECT.get())) {
            LivingEntity dropper = event.getEntity();
            if (dropper.m_217043_().m_188500_() < (Double)ConfigCommon.YELLOW_KEY_DROP_RATE.get()) {
                event.getDrops().add(new ItemEntity(dropper.f_19853_, dropper.m_20182_().f_82479_, dropper.m_20182_().f_82480_, dropper.m_20182_().f_82481_, new ItemStack((ItemLike)ItemsRegister.YELLOW_KEY.get())));
            }
            if (dropper.m_217043_().m_188500_() < (Double)ConfigCommon.BLUE_KEY_DROP_RATE.get()) {
                event.getDrops().add(new ItemEntity(dropper.f_19853_, dropper.m_20182_().f_82479_, dropper.m_20182_().f_82480_, dropper.m_20182_().f_82481_, new ItemStack((ItemLike)ItemsRegister.BLUE_KEY.get())));
            }
            if (dropper.m_217043_().m_188500_() < (Double)ConfigCommon.RED_KEY_DROP_RATE.get()) {
                event.getDrops().add(new ItemEntity(dropper.f_19853_, dropper.m_20182_().f_82479_, dropper.m_20182_().f_82480_, dropper.m_20182_().f_82481_, new ItemStack((ItemLike)ItemsRegister.RED_KEY.get())));
            }
        }
    }
}

