/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory;

import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryLinker {
    public static Result linkInventory(Level world, ItemStack stack, BlockHitResult trace) {
        BlockEntity tileEntity = world.m_7702_(trace.m_82425_());
        if (tileEntity == null || !tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
            return Result.fail(MessageTranslation.INVALID_BOUND_TILE);
        }
        boolean removed = InventoryLinker.getLinkedInventory(world, stack).map(e -> InventoryLinker.removeIfSame(stack, trace.m_82425_())).orElse(false);
        if (removed) {
            return Result.removed();
        }
        CompoundTag compound = stack.m_41784_();
        compound.m_128359_("bound_te_dim", world.m_46472_().m_135782_().toString());
        compound.m_128365_("bound_te_pos", (Tag)NbtUtils.m_129224_((BlockPos)trace.m_82425_()));
        return Result.success();
    }

    public static LazyOptional<IItemHandler> getLinkedInventory(Level world, BlockPos pos, ResourceKey<Level> registry, @Nullable ItemStack stack) {
        if (!world.m_46472_().equals(registry)) {
            return LazyOptional.empty();
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity == null) {
            if (stack != null) {
                InventoryLinker.removeDataFromStack(stack);
            }
            return LazyOptional.empty();
        }
        return tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
    }

    public static LazyOptional<IItemHandler> getLinkedInventory(Level world, ItemStack stack) {
        Pair<BlockPos, ResourceKey<Level>> dataFromStack = InventoryLinker.getDataFromStack(stack);
        if (dataFromStack == null) {
            return LazyOptional.empty();
        }
        return InventoryLinker.getLinkedInventory(world, (BlockPos)dataFromStack.getKey(), (ResourceKey<Level>)((ResourceKey)dataFromStack.getValue()), stack);
    }

    private static boolean removeIfSame(ItemStack stack, BlockPos pos) {
        Pair<BlockPos, ResourceKey<Level>> dataFromStack = InventoryLinker.getDataFromStack(stack);
        if (dataFromStack == null) {
            return false;
        }
        if (((BlockPos)dataFromStack.getKey()).equals((Object)pos)) {
            InventoryLinker.removeDataFromStack(stack);
            return true;
        }
        return false;
    }

    public static void removeDataFromStack(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        compound.m_128473_("bound_te_pos");
        compound.m_128473_("bound_te_dim");
    }

    @Nullable
    public static Pair<BlockPos, ResourceKey<Level>> getDataFromStack(ItemStack stack) {
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128441_("bound_te_pos") || !compound.m_128441_("bound_te_dim")) {
            return null;
        }
        ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("bound_te_dim")));
        return Pair.of((Object)NbtUtils.m_129239_((CompoundTag)compound.m_128469_("bound_te_pos")), (Object)dimKey);
    }

    public static final class Result {
        private final MessageTranslation i18n;
        private final boolean successful;

        public Result(MessageTranslation i18n, boolean successful) {
            this.i18n = i18n;
            this.successful = successful;
        }

        public static Result fail(MessageTranslation i18n) {
            return new Result(i18n, false);
        }

        public static Result success() {
            return new Result(MessageTranslation.BOUND_TO_TILE, true);
        }

        public static Result removed() {
            return new Result(MessageTranslation.UNBOUND_TO_TILE, true);
        }

        public MessageTranslation getI18n() {
            return this.i18n;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }
}

