/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.split;

import com.direwolf20.buildinggadgets.common.network.split.SplitPacket;
import com.google.common.collect.AbstractIterator;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;

final class PacketEncoder<MSG> {
    private final BiConsumer<MSG, FriendlyByteBuf> messageEncoder;
    private final int id;
    private short curSession;

    PacketEncoder(BiConsumer<MSG, FriendlyByteBuf> messageEncoder, int id) {
        this.messageEncoder = messageEncoder;
        this.id = id;
        this.curSession = 0;
    }

    Iterable<SplitPacket> encode(final MSG msg) {
        return new Iterable<SplitPacket>(){
            private short curSession;
            {
                short s = PacketEncoder.this.curSession;
                PacketEncoder.this.curSession = (short)(s + 1);
                this.curSession = s;
            }

            @Override
            @Nonnull
            public Iterator<SplitPacket> iterator() {
                return new AbstractIterator<SplitPacket>(){
                    private FriendlyByteBuf messageBuffer = new FriendlyByteBuf(Unpooled.buffer((int)Short.MAX_VALUE, (int)Integer.MAX_VALUE));
                    private int index = 0;
                    {
                        this.messageBuffer.markReaderIndex();
                        this.messageBuffer.markWriterIndex();
                        PacketEncoder.this.messageEncoder.accept(msg, this.messageBuffer);
                        this.messageBuffer.resetReaderIndex();
                    }

                    protected SplitPacket computeNext() {
                        FriendlyByteBuf payload;
                        boolean hasMore;
                        if (this.messageBuffer == null) {
                            return (SplitPacket)this.endOfData();
                        }
                        boolean bl = hasMore = this.messageBuffer.readableBytes() > 30000;
                        if (hasMore) {
                            payload = new FriendlyByteBuf(this.messageBuffer.copy(this.messageBuffer.readerIndex(), 30000));
                            this.messageBuffer.readerIndex(this.messageBuffer.readerIndex() + 30000);
                        } else {
                            payload = new FriendlyByteBuf(this.messageBuffer.copy());
                            this.messageBuffer = null;
                        }
                        return new SplitPacket(PacketEncoder.this.id, this.index++, curSession, hasMore, payload);
                    }
                };
            }
        };
    }
}

