/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.client.renders.BaseRenderer;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryLinker;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class PacketSetRemoteInventoryCache {
    private final boolean isCopyPaste;
    private Multiset<UniqueItem> cache;
    private Pair<BlockPos, ResourceKey<Level>> loc;

    public PacketSetRemoteInventoryCache(Multiset<UniqueItem> cache, boolean isCopyPaste) {
        this.cache = cache;
        this.isCopyPaste = isCopyPaste;
    }

    public PacketSetRemoteInventoryCache(Pair<BlockPos, ResourceKey<Level>> loc, boolean isCopyPaste) {
        this.loc = loc;
        this.isCopyPaste = isCopyPaste;
    }

    public static PacketSetRemoteInventoryCache decode(FriendlyByteBuf buf) {
        boolean isCopyPaste = buf.readBoolean();
        if (buf.readBoolean()) {
            ImmutablePair loc = new ImmutablePair((Object)buf.m_130135_(), (Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_()));
            return new PacketSetRemoteInventoryCache((Pair<BlockPos, ResourceKey<Level>>)loc, isCopyPaste);
        }
        int len = buf.readInt();
        ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
        for (int i = 0; i < len; ++i) {
            builder.addCopies((Object)new UniqueItem(Item.m_41445_((int)buf.readInt())), buf.readInt());
        }
        ImmutableMultiset cache = builder.build();
        return new PacketSetRemoteInventoryCache((Multiset<UniqueItem>)cache, isCopyPaste);
    }

    public static void encode(PacketSetRemoteInventoryCache msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isCopyPaste());
        boolean isRequest = msg.getCache() == null;
        buf.writeBoolean(isRequest);
        if (isRequest) {
            buf.writeLong(((BlockPos)msg.getLoc().getLeft()).m_121878_());
            buf.m_130085_(((ResourceKey)msg.getLoc().getRight()).m_135782_());
            return;
        }
        Set items = msg.getCache().entrySet();
        buf.writeInt(items.size());
        for (Multiset.Entry entry : items) {
            UniqueItem uniqueItem = (UniqueItem)entry.getElement();
            buf.writeInt(Item.m_41393_((Item)uniqueItem.createStack().m_41720_()));
            buf.writeInt(entry.getCount());
        }
    }

    public boolean isCopyPaste() {
        return this.isCopyPaste;
    }

    public Multiset<UniqueItem> getCache() {
        return this.cache;
    }

    public Pair<BlockPos, ResourceKey<Level>> getLoc() {
        return this.loc;
    }

    public static class Handler {
        public static void handle(PacketSetRemoteInventoryCache msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    HashSet itemTypes = new HashSet();
                    ImmutableMultiset.Builder builder = ImmutableMultiset.builder();
                    InventoryLinker.getLinkedInventory(player.f_19853_, (BlockPos)msg.loc.getKey(), (ResourceKey<Level>)((ResourceKey)msg.loc.getValue()), null).ifPresent(inventory -> {
                        for (int i = 0; i < inventory.getSlots(); ++i) {
                            Item item;
                            UniqueItem uniqueItem;
                            ItemStack stack = inventory.getStackInSlot(i);
                            if (stack.m_41619_() || itemTypes.contains(uniqueItem = new UniqueItem(item = stack.m_41720_()))) continue;
                            itemTypes.add(uniqueItem);
                            builder.addCopies((Object)uniqueItem, InventoryHelper.countInContainer(inventory, item));
                        }
                    });
                    PacketHandler.sendTo(new PacketSetRemoteInventoryCache((Multiset<UniqueItem>)builder.build(), msg.isCopyPaste()), player);
                    return;
                }
                if (msg.isCopyPaste()) {
                    EventTooltip.setCache(msg.getCache());
                } else {
                    BaseRenderer.setInventoryCache(msg.getCache());
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

