/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketChangeRange {
    private int range;

    public PacketChangeRange() {
        this.range = -1;
    }

    public PacketChangeRange(int range) {
        this.range = range;
    }

    public static void encode(PacketChangeRange msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.range);
    }

    public static PacketChangeRange decode(FriendlyByteBuf buffer) {
        return new PacketChangeRange(buffer.readInt());
    }

    public static class Handler {
        public static void handle(PacketChangeRange msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack stack = AbstractGadget.getGadget((Player)player);
                if (msg.range >= 0) {
                    GadgetUtils.setToolRange(stack, msg.range);
                } else if (stack.m_41720_() instanceof GadgetBuilding) {
                    GadgetBuilding.rangeChange((Player)player, stack);
                } else if (stack.m_41720_() instanceof GadgetExchanger) {
                    GadgetExchanger.rangeChange((Player)player, stack);
                } else if (stack.m_41720_() instanceof GadgetDestruction) {
                    GadgetDestruction.switchOverlay((Player)player, stack);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

