/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.commands;

import com.direwolf20.buildinggadgets.common.commands.AllowPlayerOverrideManager;
import com.direwolf20.buildinggadgets.common.util.lang.CommandTranslation;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.player.Player;

public final class OverrideBuildSizeCommand {
    private static final AllowPlayerOverrideManager ALLOW_LARGE_BUILDS = new AllowPlayerOverrideManager(CommandTranslation.OVERRIDE_BUILD_SIZE_NO_PLAYER, CommandTranslation.OVERRIDE_BUILD_SIZE_TOGGLED, CommandTranslation.OVERRIDE_BUILD_SIZE_LIST, "override build size");

    public static void toggleAllowLargeBuilds(Player player) {
        ALLOW_LARGE_BUILDS.toggleAllowOverride(player);
    }

    public static void toggleAllowLargeBuilds(UUID uuid) {
        ALLOW_LARGE_BUILDS.toggleAllowOverride(uuid);
    }

    public static boolean mayPerformLargeBuild(UUID uuid) {
        return ALLOW_LARGE_BUILDS.mayOverride(uuid);
    }

    public static boolean mayPerformLargeBuild(Player player) {
        return ALLOW_LARGE_BUILDS.mayOverride(player);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> registerToggle() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"OverrideBuildSize").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> OverrideBuildSizeCommand.executeToggle((CommandContext<CommandSourceStack>)context, (Player)EntityArgument.m_91474_((CommandContext)context, (String)"player"))));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> registerList() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"OverrideBuildSizeList").requires(commandSource -> commandSource.m_6761_(2))).executes(OverrideBuildSizeCommand::executeList);
    }

    private static int executeToggle(CommandContext<CommandSourceStack> context, Player player) {
        return ALLOW_LARGE_BUILDS.executeToggle(context, player);
    }

    private static int executeList(CommandContext<CommandSourceStack> context) {
        return ALLOW_LARGE_BUILDS.executeList(context);
    }
}

