/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.blocks;

import com.direwolf20.buildinggadgets.common.tileentities.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConstructionBlock
extends Block
implements EntityBlock {
    public static final Property<Boolean> BRIGHT = BooleanProperty.m_61465_((String)"bright");
    public static final Property<Boolean> NEIGHBOR_BRIGHTNESS = BooleanProperty.m_61465_((String)"neighbor_brightness");
    public static final Property<Boolean> AMBIENT_OCCLUSION = BooleanProperty.m_61465_((String)"ambient_occlusion");

    public ConstructionBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76317_).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(BRIGHT, (Comparable)Boolean.valueOf(true))).m_61124_(NEIGHBOR_BRIGHTNESS, (Comparable)Boolean.valueOf(false))).m_61124_(AMBIENT_OCCLUSION, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_49967_() {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BRIGHT, NEIGHBOR_BRIGHTNESS, AMBIENT_OCCLUSION});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)OurTileEntities.CONSTRUCTION_BLOCK_TILE_ENTITY.get()).m_155264_(blockPos, blockState);
    }

    public boolean isMimicNull(BlockState mimicBlock) {
        return mimicBlock == null || mimicBlock == Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public static BlockState getActualMimicBlock(BlockGetter blockAccess, BlockPos pos) {
        BlockEntity te = blockAccess.m_7702_(pos);
        if (te instanceof ConstructionBlockTileEntity) {
            return ((ConstructionBlockTileEntity)te).getConstructionBlockData().getState();
        }
        return null;
    }

    @Deprecated
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Boolean bright = (Boolean)state.m_61143_(BRIGHT);
        if (bright.booleanValue()) {
            return 0;
        }
        return 255;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.m_60812_(worldIn, pos) : super.m_5939_(state, worldIn, pos, selectionContext);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock((BlockGetter)worldIn, pos);
        if (!this.isMimicNull(mimic)) {
            mimic.m_60682_(worldIn, pos, entityIn);
        } else {
            super.m_7892_(state, worldIn, pos, entityIn);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.m_60647_(worldIn, pos, type) : super.m_7357_(state, worldIn, pos, type);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (state.m_60734_().equals(adjacentBlockState.m_60734_())) {
            return false;
        }
        return super.m_6104_(state, adjacentBlockState, side);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.m_60808_(worldIn, pos) : super.m_5940_(state, worldIn, pos, selectionContext);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock(worldIn, pos);
        if (!this.isMimicNull(mimic) && !mimic.m_60815_()) {
            return Shapes.m_83040_();
        }
        return !this.isMimicNull(mimic) ? mimic.m_60816_(worldIn, pos) : super.m_7952_(state, worldIn, pos);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock(worldIn, pos);
        return !this.isMimicNull(mimic) ? mimic.m_60771_(worldIn, pos, CollisionContext.m_82749_()) : super.m_6079_(state, worldIn, pos);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockState mimic = ConstructionBlock.getActualMimicBlock(reader, pos);
        return !this.isMimicNull(mimic) ? mimic.m_60631_(reader, pos) : super.m_7420_(state, reader, pos);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        Boolean bright = (Boolean)state.m_61143_(BRIGHT);
        Boolean neighborBrightness = (Boolean)state.m_61143_(NEIGHBOR_BRIGHTNESS);
        if (bright.booleanValue() || neighborBrightness.booleanValue()) {
            return 1.0f;
        }
        return 0.2f;
    }
}

