/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.util;

import cech12.bucketlib.api.BucketLibTags;
import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.BucketLibUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.ItemHandlerHelper;

public class WorldInteractionUtil {
    private WorldInteractionUtil() {
    }

    public static InteractionResult tryMilkLivingEntity(ItemStack itemStack, LivingEntity entity, Player player, InteractionHand interactionHand) {
        if (!entity.m_6095_().m_204039_(BucketLibTags.EntityTypes.MILKABLE)) {
            return InteractionResult.PASS;
        }
        player.m_21008_(interactionHand, new ItemStack((ItemLike)Items.f_42446_));
        InteractionResult result = player.m_36157_((Entity)entity, interactionHand);
        if (result.m_19077_()) {
            itemStack = ItemUtils.m_41813_((ItemStack)itemStack.m_41777_(), (Player)player, (ItemStack)BucketLibUtil.addMilk(ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1)));
        }
        player.m_21008_(interactionHand, itemStack);
        return result;
    }

    public static InteractionResultHolder<ItemStack> tryPickupFromCauldron(Level level, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        BlockPos hitBlockPos = blockHitResult.m_82425_();
        BlockState hitBlockState = level.m_8055_(hitBlockPos);
        Block hitBlock = hitBlockState.m_60734_();
        if (hitBlock instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)hitBlock;
            Item item = itemstack.m_41720_();
            if (item instanceof UniversalBucketItem) {
                UniversalBucketItem bucketItem = (UniversalBucketItem)item;
                if (BucketLibUtil.isEmpty(itemstack) && (cauldronBlock == Blocks.f_152477_ && bucketItem.canHoldFluid((Fluid)Fluids.f_76195_) || cauldronBlock == Blocks.f_152476_ && bucketItem.canHoldFluid((Fluid)Fluids.f_76193_) || cauldronBlock == Blocks.f_152478_ && bucketItem.canHoldBlock(Blocks.f_152499_))) {
                    player.m_21008_(interactionHand, new ItemStack((ItemLike)Items.f_42446_));
                    InteractionResult interactionResult = hitBlockState.m_60664_(level, player, interactionHand, blockHitResult);
                    ItemStack resultItemStack = player.m_21120_(interactionHand);
                    player.m_21008_(interactionHand, itemstack);
                    if (interactionResult.m_19077_()) {
                        if (resultItemStack.m_41720_() == Items.f_151055_) {
                            return new InteractionResultHolder(interactionResult, (Object)ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)BucketLibUtil.addBlock(ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack, (int)1), Blocks.f_152499_)));
                        }
                        FluidStack resultFluidStack = FluidUtil.getFluidContained((ItemStack)resultItemStack).orElse(FluidStack.EMPTY);
                        return new InteractionResultHolder(interactionResult, (Object)ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)BucketLibUtil.addFluid(ItemHandlerHelper.copyStackWithSize((ItemStack)itemstack, (int)1), resultFluidStack.getFluid())));
                    }
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public static InteractionResultHolder<ItemStack> tryPlaceIntoCauldron(Level level, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        BlockPos hitBlockPos = blockHitResult.m_82425_();
        BlockState hitBlockState = level.m_8055_(hitBlockPos);
        Block hitBlock = hitBlockState.m_60734_();
        if (hitBlock instanceof AbstractCauldronBlock) {
            AbstractCauldronBlock cauldronBlock = (AbstractCauldronBlock)hitBlock;
            if (itemstack.m_41720_() instanceof UniversalBucketItem && cauldronBlock == Blocks.f_50256_ && !BucketLibUtil.containsEntityType(itemstack)) {
                Fluid bucketFluid = BucketLibUtil.getFluid(itemstack);
                Block bucketBlock = BucketLibUtil.getBlock(itemstack);
                if (bucketFluid == Fluids.f_76195_ || bucketFluid == Fluids.f_76193_) {
                    player.m_21008_(interactionHand, new ItemStack((ItemLike)bucketFluid.m_6859_()));
                    InteractionResult interactionResult = hitBlockState.m_60664_(level, player, interactionHand, blockHitResult);
                    player.m_21008_(interactionHand, itemstack);
                    if (interactionResult.m_19077_()) {
                        return new InteractionResultHolder(interactionResult, (Object)BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeFluid(itemstack), interactionHand));
                    }
                } else if (bucketBlock == Blocks.f_152499_) {
                    player.m_21008_(interactionHand, new ItemStack((ItemLike)Items.f_151055_));
                    InteractionResult interactionResult = hitBlockState.m_60664_(level, player, interactionHand, blockHitResult);
                    player.m_21008_(interactionHand, itemstack);
                    if (interactionResult.m_19077_()) {
                        return new InteractionResultHolder(interactionResult, (Object)BucketLibUtil.createEmptyResult(itemstack, player, BucketLibUtil.removeBlock(itemstack), interactionHand));
                    }
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }
}

