/*
 * Decompiled with CFR 0.152.
 */
package cech12.bucketlib.item;

import cech12.bucketlib.api.item.UniversalBucketItem;
import cech12.bucketlib.util.BucketLibUtil;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class UniversalBucketFluidHandler
extends FluidHandlerItemStack {
    public UniversalBucketFluidHandler(@Nonnull ItemStack container) {
        super(container, 1000);
    }

    @Nonnull
    public FluidStack getFluid() {
        ResourceLocation bucketContent;
        FluidStack fluidStack = super.getFluid();
        if (fluidStack.isEmpty() && ForgeMod.MILK.isPresent() && (bucketContent = BucketLibUtil.getContent(this.container)) != null && bucketContent.equals((Object)BucketLibUtil.MILK_LOCATION)) {
            fluidStack = new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
            this.setFluid(fluidStack);
        }
        return fluidStack;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (BucketLibUtil.containsMilk(this.getContainer())) {
            return 0;
        }
        if (resource.getAmount() < this.capacity) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (BucketLibUtil.containsEntityType(this.getContainer())) {
            return FluidStack.EMPTY;
        }
        if (!ForgeMod.MILK.isPresent() && BucketLibUtil.containsMilk(this.getContainer())) {
            return FluidStack.EMPTY;
        }
        if (maxDrain < this.capacity) {
            return FluidStack.EMPTY;
        }
        if (action == IFluidHandler.FluidAction.EXECUTE && BucketLibUtil.isAffectedByInfinityEnchantment(this.container)) {
            return super.drain(maxDrain, IFluidHandler.FluidAction.SIMULATE);
        }
        return super.drain(maxDrain, action);
    }

    protected void setContainerToEmpty() {
        boolean wasCracked = false;
        Item item = this.container.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            wasCracked = bucketItem.isCracked(this.container);
        }
        super.setContainerToEmpty();
        if (wasCracked) {
            this.container.m_41774_(1);
        } else {
            if (BucketLibUtil.containsContent(this.container)) {
                BucketLibUtil.removeContentNoCopy(this.container, false);
            }
            BucketLibUtil.damageByOne(this.container);
        }
    }

    public boolean canFillFluidType(FluidStack fluid) {
        Item item = this.container.m_41720_();
        if (item instanceof UniversalBucketItem) {
            UniversalBucketItem bucketItem = (UniversalBucketItem)item;
            return fluid.getFluid() != Fluids.f_76191_ && bucketItem.canHoldFluid(fluid.getFluid());
        }
        return super.canFillFluidType(fluid);
    }
}

