/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.mixin;

import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.fluid.FluidApi;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin {
    @Shadow
    @Nullable
    public abstract Level m_58904_();

    @Shadow
    public abstract BlockPos m_58899_();

    @Shadow
    public abstract BlockState m_58900_();

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void deserializeData(CompoundTag compoundTag, CallbackInfo ci) {
        Object energyContainer;
        Object fluidContainer = FluidApi.getAPIFluidContainer(this.m_58904_(), this.m_58899_(), this.m_58900_(), (BlockEntity)this, null);
        if (fluidContainer != null) {
            fluidContainer.deserialize(compoundTag);
        }
        if ((energyContainer = EnergyApi.getAPIEnergyContainer(this.m_58904_(), this.m_58899_(), this.m_58900_(), (BlockEntity)this, null)) != null) {
            energyContainer.deserialize(compoundTag);
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    public void serializeData(CompoundTag compoundTag, CallbackInfo ci) {
        Object energyContainer;
        Object fluidContainer = FluidApi.getAPIFluidContainer(this.m_58904_(), this.m_58899_(), this.m_58900_(), (BlockEntity)this, null);
        if (fluidContainer != null) {
            fluidContainer.serialize(compoundTag);
        }
        if ((energyContainer = EnergyApi.getAPIEnergyContainer(this.m_58904_(), this.m_58899_(), this.m_58900_(), (BlockEntity)this, null)) != null) {
            energyContainer.serialize(compoundTag);
        }
    }
}

