/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.util.Updatable;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ForgeItemEnergyContainer<T extends EnergyContainer & Updatable>(T container) implements IEnergyStorage,
ICapabilityProvider
{
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        LazyOptional of = LazyOptional.of(() -> this);
        return capability.orEmpty(ForgeCapabilities.ENERGY, of.cast()).cast();
    }

    public int receiveEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int inserted = (int)this.container.insertEnergy(maxAmount, bl);
        if (!bl) {
            ((Updatable)this.container).update();
        }
        return inserted;
    }

    public int extractEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int extracted = (int)this.container.extractEnergy(maxAmount, bl);
        if (!bl) {
            ((Updatable)this.container).update();
        }
        return extracted;
    }

    public int getEnergyStored() {
        return (int)this.container.getStoredEnergy();
    }

    public int getMaxEnergyStored() {
        return (int)this.container.getMaxCapacity();
    }

    public boolean canExtract() {
        return this.container.allowsExtraction();
    }

    public boolean canReceive() {
        return this.container.allowsInsertion();
    }
}

