/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mod.pianomanu.blockcarpentry.bakedmodels.ModelInformation;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.IFrameTile;
import mod.pianomanu.blockcarpentry.util.ExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureHelper {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<TextureAtlasSprite> getGlassTextures() {
        ArrayList<TextureAtlasSprite> glassTextures = new ArrayList<TextureAtlasSprite>();
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/white_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/orange_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/magenta_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/light_blue_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/yellow_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/lime_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/pink_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/gray_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/light_gray_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/cyan_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/purple_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/blue_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/brown_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/green_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/red_stained_glass")));
        glassTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/black_stained_glass")));
        return glassTextures;
    }

    public static List<TextureAtlasSprite> getWoolTextures() {
        ArrayList<TextureAtlasSprite> woolTextures = new ArrayList<TextureAtlasSprite>();
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/white_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/orange_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/magenta_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/light_blue_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/yellow_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/lime_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/pink_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/gray_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/light_gray_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/cyan_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/purple_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/blue_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/brown_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/green_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/red_wool")));
        woolTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/black_wool")));
        return woolTextures;
    }

    public static List<TextureAtlasSprite> getPlanksTextures() {
        ArrayList<TextureAtlasSprite> planksTextures = new ArrayList<TextureAtlasSprite>();
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/oak_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/birch_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/spruce_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/jungle_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/acacia_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/dark_oak_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/crimson_planks")));
        planksTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/warped_planks")));
        return planksTextures;
    }

    public static List<TextureAtlasSprite> getMetalTextures() {
        ArrayList<TextureAtlasSprite> metalTextures = new ArrayList<TextureAtlasSprite>();
        metalTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/iron_block")));
        metalTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/obsidian")));
        metalTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/stone")));
        metalTextures.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TextureHelper.loc("block/oak_log")));
        return metalTextures;
    }

    public static List<TextureAtlasSprite> getTextureFromModel(BakedModel model, ModelData extraData, RandomSource rand) {
        return TextureHelper.getTextureFromModel(model, (BlockState)extraData.get(FrameBlockTile.MIMIC), extraData, rand);
    }

    public static List<TextureAtlasSprite> getTextureFromModel(BakedModel model, BlockState state, RandomSource rand) {
        return TextureHelper.getTextureFromModel(model, state, ModelData.EMPTY, rand);
    }

    public static List<TextureAtlasSprite> getTextureFromModel(BakedModel model, BlockState state, ModelData extraData, RandomSource rand) {
        ArrayList<TextureAtlasSprite> textureList = new ArrayList<TextureAtlasSprite>();
        try {
            for (Direction dir : Direction.values()) {
                for (BakedQuad quad : model.getQuads(state, dir, rand, extraData, null)) {
                    if (textureList.contains(quad.m_173410_())) continue;
                    textureList.add(quad.m_173410_());
                }
            }
            return textureList;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return new ArrayList<TextureAtlasSprite>();
        }
    }

    public static List<TextureAtlasSprite> getTextures(BlockState state) {
        try {
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(BlockModelShaper.m_110895_((BlockState)state));
            RandomSource rand = Minecraft.m_91087_().f_91073_ != null ? Minecraft.m_91087_().f_91073_.f_46441_ : RandomSource.m_216327_();
            return TextureHelper.getTextureFromModel(model, state, rand);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static List<TextureAtlasSprite> getTextures(IFrameTile tile) {
        return TextureHelper.getTextures(tile.getMimic());
    }

    public static TextureAtlasSprite getTextureFromTileEntity(IFrameTile tile) {
        List<TextureAtlasSprite> sprites = TextureHelper.getTextures(tile);
        if (sprites.size() > 0 && tile.getTexture() < sprites.size()) {
            return sprites.get(tile.getTexture());
        }
        return sprites.size() > 0 ? sprites.get(0) : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(MissingTextureAtlasSprite.m_118071_());
    }

    private static ResourceLocation loc(String path) {
        return new ResourceLocation("minecraft", path);
    }

    public static TextureAtlasSprite getTexture(BakedModel model, @Nonnull RandomSource rand, @Nonnull ModelData extraData, ModelProperty<Integer> modelPropertyTexture) {
        List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
        if (TextureHelper.badTextureList(textureList)) {
            return TextureHelper.getMissingTexture();
        }
        Integer tex = (Integer)extraData.get(modelPropertyTexture);
        if (tex == null) {
            LOGGER.error("Cannot determine model texture for model " + model);
            return TextureHelper.getMissingTexture();
        }
        if (textureList.size() <= tex) {
            extraData.derive().with(modelPropertyTexture, (Object)0);
            tex = 0;
        }
        TextureAtlasSprite texture = textureList.get(tex);
        return texture;
    }

    public static TextureAtlasSprite getTexture(BakedModel model, ModelData extraData, RandomSource rand, Direction direction) {
        List<TextureAtlasSprite> textureList = TextureHelper.getTextureFromModel(model, extraData, rand);
        if (TextureHelper.badTextureList(textureList)) {
            return TextureHelper.getMissingTexture();
        }
        TextureAtlasSprite texture = textureList.get(0);
        for (BakedQuad quad : model.getQuads((BlockState)extraData.get(FrameBlockTile.MIMIC), direction, rand, extraData, RenderType.m_110466_())) {
            texture = quad.m_173410_();
        }
        return texture;
    }

    private static boolean badTextureList(List<TextureAtlasSprite> textureList) {
        return textureList.size() == 0;
    }

    public static TextureAtlasSprite getMissingTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("missing"));
    }

    public static ModelInformation getOverlayModelInformation(int overlayIndex) {
        int tintIndex = -1;
        TextureAtlasSprite overlay = null;
        TextureAtlasSprite upOverlay = null;
        TextureAtlasSprite downOverlay = null;
        if (overlayIndex == 1) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/grass_block_side_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/grass_block_top"));
        }
        if (overlayIndex == 2) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/grass_block_side_overlay_large"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/grass_block_top"));
        }
        if (overlayIndex == 3) {
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/grass_block_snow_overlay"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/snow"));
        }
        if (overlayIndex == 4) {
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/grass_block_snow_overlay_small"));
            upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/snow"));
        }
        if (overlayIndex == 5) {
            tintIndex = 1;
            overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/vine"));
        }
        if (overlayIndex >= 6 && overlayIndex <= 10) {
            if (overlayIndex == 6) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/stone_brick_overlay"));
            }
            if (overlayIndex == 7) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/brick_overlay"));
            }
            if (overlayIndex == 8) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_sandstone_overlay"));
            }
            if (overlayIndex == 9) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/boundary_overlay"));
            }
            if (overlayIndex == 10) {
                overlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
                upOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
                downOverlay = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("blockcarpentry", "block/chiseled_stone_overlay"));
            }
        }
        ArrayList<TextureAtlasSprite> textures = new ArrayList<TextureAtlasSprite>();
        textures.add(overlay);
        textures.add(overlay);
        textures.add(overlay);
        textures.add(overlay);
        textures.add(upOverlay);
        textures.add(downOverlay);
        return new ModelInformation(textures, tintIndex, overlayIndex);
    }
}

