/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OverlayHelper {
    private static final String[] messageStrings = new String[]{"", "message.blockcarpentry.grass_overlay", "message.blockcarpentry.grass_overlay_large", "message.blockcarpentry.snow_overlay", "message.blockcarpentry.snow_overlay_small", "message.blockcarpentry.vine_overlay", "message.blockcarpentry.special_overlay", "message.blockcarpentry.special_overlay", "message.blockcarpentry.special_overlay", "message.blockcarpentry.special_overlay", "message.blockcarpentry.special_overlay"};

    public static boolean setOverlay(Level level, BlockPos pos, Player player, int lowerBound, int upperBound) {
        return OverlayHelper.setOverlay(level, pos, player, lowerBound, upperBound, 0);
    }

    public static boolean setOverlay(Level level, BlockPos pos, Player player, int lowerBound, int upperBound, int messageIndexOffset) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof FrameBlockTile) {
            FrameBlockTile fte = (FrameBlockTile)tileEntity;
            OverlayHelper.setOverlayBaseFrameCycle(fte, player, lowerBound, upperBound, messageIndexOffset);
            return true;
        }
        if (tileEntity instanceof TwoBlocksFrameBlockTile) {
            TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
            boolean condition = fte.getOverlay() < upperBound && fte.getOverlay() >= lowerBound && !fte.applyToUpper() || fte.getOverlay_2() < upperBound && fte.getOverlay_2() >= lowerBound && fte.applyToUpper();
            OverlayHelper.setOverlayTwoBlocksFrameCycle(condition, fte, player, lowerBound, messageIndexOffset);
            return true;
        }
        return false;
    }

    private static void setOverlayBaseFrameCycle(FrameBlockTile fte, Player player, int lowerBound, int upperBound, int messageIndexOffset) {
        if (fte.getOverlay() < upperBound && fte.getOverlay() >= lowerBound) {
            OverlayHelper.setOverlayBaseFrame(fte, player, fte.getOverlay() + 1, messageIndexOffset);
        } else {
            OverlayHelper.setOverlayBaseFrame(fte, player, lowerBound, messageIndexOffset);
        }
    }

    private static void setOverlayTwoBlocksFrameCycle(boolean condition, TwoBlocksFrameBlockTile fte, Player player, int lowerBound, int messageIndexOffset) {
        if (condition) {
            OverlayHelper.setOverlayTwoBlocksFrame(fte, player, !fte.applyToUpper() ? fte.getOverlay() + 1 : fte.getOverlay_2() + 1, messageIndexOffset);
        } else {
            OverlayHelper.setOverlayTwoBlocksFrame(fte, player, lowerBound, messageIndexOffset);
        }
    }

    private static void setOverlayBaseFrame(FrameBlockTile fte, Player player, int newOverlay, int messageIndexOffset) {
        fte.setOverlay(newOverlay);
        int messageIndex = messageIndexOffset == 0 ? 0 : newOverlay - messageIndexOffset;
        player.m_5661_((Component)Component.m_237110_((String)messageStrings[newOverlay], (Object[])new Object[]{messageIndex}), true);
    }

    private static void setOverlayTwoBlocksFrame(TwoBlocksFrameBlockTile fte, Player player, int newOverlay, int messageIndexOffset) {
        if (!fte.applyToUpper()) {
            fte.setOverlay(newOverlay);
        } else {
            fte.setOverlay_2(newOverlay);
        }
        int messageIndex = messageIndexOffset == 0 ? 0 : newOverlay - messageIndexOffset;
        player.m_5661_((Component)Component.m_237110_((String)messageStrings[newOverlay], (Object[])new Object[]{messageIndex}), true);
    }
}

