/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import java.util.ArrayList;
import java.util.Objects;
import mod.pianomanu.blockcarpentry.block.BedFrameBlock;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.BedFrameTile;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameBlockEntity;
import mod.pianomanu.blockcarpentry.tileentity.DaylightDetectorFrameTileEntity;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.IFrameTile;
import mod.pianomanu.blockcarpentry.tileentity.SignFrameTile;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.FrameInteractionItems;
import mod.pianomanu.blockcarpentry.util.OverlayHelper;
import mod.pianomanu.blockcarpentry.util.Tags;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockAppearanceHelper {
    public static boolean setAll(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player) {
        return BlockAppearanceHelper.setLightLevel(itemStack, state, level, pos, player) || BlockAppearanceHelper.setTexture(itemStack, state, level, player, pos) || BlockAppearanceHelper.setDesign(level, pos, player, itemStack) || BlockAppearanceHelper.setDesignTexture(level, pos, player, itemStack) || BlockAppearanceHelper.setColor(level, pos, itemStack) || BlockAppearanceHelper.setOverlay(level, pos, player, itemStack) || BlockAppearanceHelper.setRotation(level, pos, player, itemStack);
    }

    public static boolean setLightLevel(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player) {
        if (((Boolean)BCModConfig.LIGHTING_ENABLED.get()).booleanValue()) {
            if (itemStack.m_41720_() == Items.f_42525_ && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) < 13) {
                int count = itemStack.m_41613_();
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BCBlockStateProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(state.m_60734_().getLightEmission(state, (BlockGetter)level, pos) + 3)), 3);
                itemStack.m_41764_(count - 1);
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{(Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) + 3}), true);
                return true;
            }
            if ((itemStack.m_41720_() == Items.f_42413_ || itemStack.m_41720_() == Items.f_42414_) && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) < 15) {
                int count = itemStack.m_41613_();
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BCBlockStateProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(state.m_60734_().getLightEmission(state, (BlockGetter)level, pos) + 1)), 3);
                itemStack.m_41764_(count - 1);
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{(Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) + 1}), true);
                return true;
            }
            if (itemStack.m_41720_() == Items.f_42525_ && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) >= 13) {
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL)}), true);
            }
            if ((itemStack.m_41720_() == Items.f_42413_ || itemStack.m_41720_() == Items.f_42414_) && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) == 15) {
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL)}), true);
            }
        }
        return false;
    }

    public static boolean setTexture(ItemStack itemStack, BlockState state, Level level, Player player, BlockPos pos) {
        if (itemStack.m_41720_() == Registration.TEXTURE_WRENCH.get() && !player.m_6047_() && ((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() && Tags.isFrameBlock(state.m_60734_())) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    int len;
                    int n = len = TextureHelper.getTextures(fte.getMimic()).size() == 0 ? 6 : TextureHelper.getTextures(fte.getMimic()).size();
                    if (fte.getTexture() < len - 1) {
                        fte.setTexture(fte.getTexture() + 1);
                    } else {
                        fte.setTexture(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture() + 1}), true);
                } else {
                    int len;
                    int n = len = TextureHelper.getTextures(fte.getMimic_2()).size() == 0 ? 6 : TextureHelper.getTextures(fte.getMimic_2()).size();
                    if (fte.getTexture_2() < len - 1) {
                        fte.setTexture_2(fte.getTexture_2() + 1);
                    } else {
                        fte.setTexture_2(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture_2() + 1}), true);
                }
            } else if (tileEntity instanceof IFrameTile) {
                int len;
                IFrameTile fte = (IFrameTile)tileEntity;
                int n = len = TextureHelper.getTextures(fte).size() == 0 ? 6 : TextureHelper.getTextures(fte).size();
                if (fte.getTexture() < len - 1) {
                    fte.setTexture(fte.getTexture() + 1);
                } else {
                    fte.setTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture() + 1}), true);
            }
            return true;
        }
        return false;
    }

    public static boolean setDesign(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Registration.CHISEL.get() && !player.m_6047_()) {
            IFrameTile fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                if (level.m_8055_(pos).m_60734_() != Registration.FRAMEBLOCK.get() && level.m_8055_(pos).m_60734_() != Registration.ILLUSION_BLOCK.get()) {
                    int n = ((FrameBlockTile)fte).getDesign();
                    Objects.requireNonNull(fte);
                    if (n < 4) {
                        ((FrameBlockTile)fte).setDesign(((FrameBlockTile)fte).getDesign() + 1);
                    } else {
                        ((FrameBlockTile)fte).setDesign(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((FrameBlockTile)fte).getDesign()}), true);
                }
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                int n = ((BedFrameTile)fte).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((BedFrameTile)fte).setDesign(((BedFrameTile)fte).getDesign() + 1);
                } else {
                    ((BedFrameTile)fte).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((BedFrameTile)fte).getDesign()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                int n = ((ChestFrameBlockEntity)fte).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((ChestFrameBlockEntity)fte).setDesign(((ChestFrameBlockEntity)fte).getDesign() + 1);
                } else {
                    ((ChestFrameBlockEntity)fte).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((ChestFrameBlockEntity)fte).getDesign()}), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                fte = (TwoBlocksFrameBlockTile)tileEntity;
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    int n = ((TwoBlocksFrameBlockTile)fte).getDesign();
                    Objects.requireNonNull(fte);
                    if (n < 4) {
                        ((TwoBlocksFrameBlockTile)fte).setDesign(((TwoBlocksFrameBlockTile)fte).getDesign() + 1);
                    } else {
                        ((TwoBlocksFrameBlockTile)fte).setDesign(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((TwoBlocksFrameBlockTile)fte).getDesign()}), true);
                } else {
                    int n = ((TwoBlocksFrameBlockTile)fte).getDesign_2();
                    Objects.requireNonNull(fte);
                    if (n < 4) {
                        ((TwoBlocksFrameBlockTile)fte).setDesign_2(((TwoBlocksFrameBlockTile)fte).getDesign_2() + 1);
                    } else {
                        ((TwoBlocksFrameBlockTile)fte).setDesign_2(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((TwoBlocksFrameBlockTile)fte).getDesign_2()}), true);
                }
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                fte = (DaylightDetectorFrameTileEntity)tileEntity;
                int n = ((FrameBlockTile)fte).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((FrameBlockTile)fte).setDesign(((FrameBlockTile)fte).getDesign() + 1);
                } else {
                    ((FrameBlockTile)fte).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((FrameBlockTile)fte).getDesign()}), true);
            }
            return true;
        }
        return false;
    }

    public static boolean setDesignTexture(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Registration.PAINTBRUSH.get() && !player.m_6047_()) {
            IFrameTile fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                if (level.m_8055_(pos).m_60734_() != Registration.FRAMEBLOCK.get() && level.m_8055_(pos).m_60734_() != Registration.ILLUSION_BLOCK.get()) {
                    int n = ((FrameBlockTile)fte).getDesignTexture();
                    Objects.requireNonNull(fte);
                    if (n < 4) {
                        ((FrameBlockTile)fte).setDesignTexture(((FrameBlockTile)fte).getDesignTexture() + 1);
                    } else {
                        ((FrameBlockTile)fte).setDesignTexture(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design_texture", (Object[])new Object[]{((FrameBlockTile)fte).getDesignTexture()}), true);
                }
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                if (((BedFrameTile)fte).getDesignTexture() < 7) {
                    ((BedFrameTile)fte).setDesignTexture(((BedFrameTile)fte).getDesignTexture() + 1);
                } else {
                    ((BedFrameTile)fte).setDesignTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design_texture", (Object[])new Object[]{((BedFrameTile)fte).getDesignTexture()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                int n = ((ChestFrameBlockEntity)fte).getDesignTexture();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((ChestFrameBlockEntity)fte).setDesignTexture(((ChestFrameBlockEntity)fte).getDesignTexture() + 1);
                } else {
                    ((ChestFrameBlockEntity)fte).setDesignTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design_texture", (Object[])new Object[]{((ChestFrameBlockEntity)fte).getDesignTexture()}), true);
            }
            return true;
        }
        return false;
    }

    public static boolean setColor(Level level, BlockPos pos, ItemStack itemStack) {
        if (FrameInteractionItems.isDyeItem(itemStack.m_41720_())) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                FrameBlockTile fte = (FrameBlockTile)tileEntity;
                fte.setGlassColor(BlockAppearanceHelper.dyeItemToInt(itemStack.m_41720_()) + 1);
                return true;
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                DaylightDetectorFrameTileEntity fte = (DaylightDetectorFrameTileEntity)tileEntity;
                fte.setGlassColor(BlockAppearanceHelper.dyeItemToInt(itemStack.m_41720_()) + 1);
                return true;
            }
            if (tileEntity instanceof BedFrameTile) {
                BedFrameTile fte = (BedFrameTile)tileEntity;
                if (level.m_8055_(pos).m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    fte.setBlanketColor(BlockAppearanceHelper.dyeItemToInt(itemStack.m_41720_()));
                    return true;
                }
                if (level.m_8055_(pos).m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    fte.setPillowColor(BlockAppearanceHelper.dyeItemToInt(itemStack.m_41720_()));
                    return true;
                }
            }
        }
        return false;
    }

    public static Integer dyeItemToInt(Item item) {
        ArrayList<Item> colors = new ArrayList<Item>(FrameInteractionItems.getDyeItems());
        if (colors.contains(item)) {
            return colors.indexOf(item);
        }
        return 0;
    }

    public static boolean setOverlay(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_().equals(Items.f_41864_)) {
            return OverlayHelper.setOverlay(level, pos, player, 1, 2);
        }
        if (itemStack.m_41720_().equals(Items.f_42452_)) {
            return OverlayHelper.setOverlay(level, pos, player, 3, 4);
        }
        if (itemStack.m_41720_().equals(Items.f_42029_)) {
            return OverlayHelper.setOverlay(level, pos, player, 5, 5);
        }
        if (itemStack.m_41720_().equals(Items.f_42403_)) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                FrameBlockTile fte = (FrameBlockTile)tileEntity;
                return OverlayHelper.setOverlay(level, pos, player, 6, 10, 5);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                BlockState state = level.m_8055_(pos);
                return OverlayHelper.setOverlay(level, pos, player, 6, 10, 5);
            }
            return true;
        }
        return false;
    }

    public static int setTintIndex(BlockState state) {
        Block b = state.m_60734_();
        if (b instanceof GrassBlock || b instanceof LeavesBlock) {
            return 1;
        }
        return -1;
    }

    public static boolean setRotation(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Registration.TEXTURE_WRENCH.get() && !player.m_6047_() && Tags.isIllusionBlock(level.m_8055_(pos).m_60734_())) {
            IFrameTile fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                if (!level.m_8055_(pos).m_60734_().equals(Registration.ILLUSION_BLOCK.get())) {
                    if (((FrameBlockTile)fte).getRotation() < 11) {
                        ((FrameBlockTile)fte).setRotation(((FrameBlockTile)fte).getRotation() + 1);
                    } else {
                        ((FrameBlockTile)fte).setRotation(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((FrameBlockTile)fte).getRotation()}), true);
                }
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                if (((BedFrameTile)fte).getRotation() < 11) {
                    ((BedFrameTile)fte).setRotation(((BedFrameTile)fte).getRotation() + 1);
                } else {
                    ((BedFrameTile)fte).setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((BedFrameTile)fte).getRotation()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                if (((ChestFrameBlockEntity)fte).getRotation() < 11) {
                    ((ChestFrameBlockEntity)fte).setRotation(((ChestFrameBlockEntity)fte).getRotation() + 1);
                } else {
                    ((ChestFrameBlockEntity)fte).setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((ChestFrameBlockEntity)fte).getRotation()}), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                fte = (TwoBlocksFrameBlockTile)tileEntity;
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    if (((TwoBlocksFrameBlockTile)fte).getRotation() < 11) {
                        ((TwoBlocksFrameBlockTile)fte).setRotation(((TwoBlocksFrameBlockTile)fte).getRotation() + 1);
                    } else {
                        ((TwoBlocksFrameBlockTile)fte).setRotation(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((TwoBlocksFrameBlockTile)fte).getRotation()}), true);
                } else {
                    if (((TwoBlocksFrameBlockTile)fte).getRotation_2() < 11) {
                        ((TwoBlocksFrameBlockTile)fte).setRotation_2(((TwoBlocksFrameBlockTile)fte).getRotation_2() + 1);
                    } else {
                        ((TwoBlocksFrameBlockTile)fte).setRotation_2(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((TwoBlocksFrameBlockTile)fte).getRotation_2()}), true);
                }
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                fte = (DaylightDetectorFrameTileEntity)tileEntity;
                if (((FrameBlockTile)fte).getRotation() < 7) {
                    ((FrameBlockTile)fte).setRotation(((FrameBlockTile)fte).getRotation() + 1);
                } else {
                    ((FrameBlockTile)fte).setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((FrameBlockTile)fte).getRotation()}), true);
            }
            if (tileEntity instanceof SignFrameTile) {
                fte = (SignFrameTile)tileEntity;
                if (((SignFrameTile)fte).getRotation() < 7) {
                    ((SignFrameTile)fte).setRotation(((SignFrameTile)fte).getRotation() + 1);
                } else {
                    ((SignFrameTile)fte).setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{((SignFrameTile)fte).getRotation()}), true);
            }
            return true;
        }
        return false;
    }
}

