/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.renderer.block;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import mod.pianomanu.blockcarpentry.block.StandingSignFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.tileentity.SignFrameTile;
import mod.pianomanu.blockcarpentry.util.BCWoodType;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

public class FrameSignRenderer
implements BlockEntityRenderer<SignFrameTile> {
    public static final int MAX_LINE_WIDTH = 90;
    private static final int LINE_HEIGHT = 10;
    private static final String STICK = "stick";
    private static final int BLACK_TEXT_OUTLINE_COLOR = -988212;
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final BlockEntityRendererProvider.Context context;
    private final Font font;

    public FrameSignRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.font = context.m_173586_();
    }

    private static LayerDefinition createSignLayer(BlockState tileState) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        if (tileState.m_61138_((Property)StandingSignBlock.f_56987_)) {
            partdefinition.m_171599_(STICK, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 14.0f, 2.0f), PartPose.f_171404_);
        } else {
            partdefinition.m_171599_(STICK, CubeListBuilder.m_171558_(), PartPose.f_171404_);
        }
        for (int i = 0; i < 24; ++i) {
            String partName = "sign" + i;
            partdefinition.m_171599_(partName, CubeListBuilder.m_171558_().m_171514_(i % 10, 0).m_171481_(-12.0f + (float)i, -14.0f, -1.0f, 1.0f, 12.0f, 2.0f), PartPose.f_171404_);
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    private static boolean isOutlineVisible(SignFrameTile blockEntity, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)blockEntity.m_58899_())) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static int getDarkColor(SignFrameTile blockEntity) {
        int textColor = blockEntity.m_59753_().m_41071_();
        double d0 = 0.4;
        int r = (int)((double)NativeImage.m_85085_((int)textColor) * d0);
        int g = (int)((double)NativeImage.m_85103_((int)textColor) * d0);
        int b = (int)((double)NativeImage.m_85119_((int)textColor) * d0);
        return textColor == DyeColor.BLACK.m_41071_() && blockEntity.m_155727_() ? -988212 : NativeImage.m_84992_((int)0, (int)b, (int)g, (int)r);
    }

    public void render(SignFrameTile signFrameTile, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedOverlay, int packedLight) {
        BlockState mimic = signFrameTile.getMimic();
        if (((Boolean)signFrameTile.m_58900_().m_61143_((Property)StandingSignFrameBlock.CONTAINS_BLOCK)).booleanValue() && mimic != null) {
            this.renderSign(signFrameTile, poseStack, buffer, combinedOverlay, packedLight);
        } else {
            this.renderEmpty(signFrameTile, poseStack, buffer, combinedOverlay, packedLight);
        }
    }

    private void renderSign(SignFrameTile tile, PoseStack stack, MultiBufferSource buffer, int combinedOverlay, int packedLight) {
        this.prepareStack(tile.m_58900_(), stack);
        TextureAtlasSprite sprite = TextureHelper.getTextureFromTileEntity(tile);
        Material material = new Material(TextureAtlas.f_118259_, sprite.m_118413_());
        LayerDefinition layerDefinition = FrameSignRenderer.createSignLayer(tile.m_58900_());
        FrameSignModel signrenderer$signmodel = new FrameSignModel(layerDefinition.m_171564_());
        VertexConsumer vertexconsumer = material.m_119194_(buffer, arg_0 -> ((FrameSignModel)signrenderer$signmodel).m_103119_(arg_0));
        signrenderer$signmodel.root.m_104301_(stack, vertexconsumer, combinedOverlay, packedLight);
        this.drawText(tile, stack, buffer, combinedOverlay);
    }

    private void renderEmpty(SignFrameTile tile, PoseStack stack, MultiBufferSource buffer, int combinedOverlay, int packedLight) {
        WoodType woodtype = tile.m_58900_().m_60734_().equals(Registration.STANDING_SIGN_FRAMEBLOCK.get()) ? BCWoodType.FRAME : BCWoodType.ILLUSION;
        SignRenderer.SignModel signrenderer$signmodel = new SignRenderer.SignModel(this.context.m_173582_(ModelLayers.m_171291_((WoodType)woodtype)));
        signrenderer$signmodel.f_112507_.f_104207_ = tile.m_58900_().m_60734_() instanceof StandingSignBlock;
        this.prepareStack(tile.m_58900_(), stack);
        Material material = Sheets.m_173381_((WoodType)woodtype);
        VertexConsumer vertexconsumer = material.m_119194_(buffer, arg_0 -> ((SignRenderer.SignModel)signrenderer$signmodel).m_103119_(arg_0));
        signrenderer$signmodel.f_173655_.m_104301_(stack, vertexconsumer, combinedOverlay, packedLight);
        this.drawText(tile, stack, buffer, combinedOverlay);
    }

    private void prepareStack(BlockState state, PoseStack stack) {
        stack.m_85836_();
        float scaleFactor = 0.6666667f;
        if (state.m_60734_() instanceof StandingSignBlock) {
            stack.m_85837_(0.5, 0.5, 0.5);
            float f1 = -((float)((Integer)state.m_61143_((Property)StandingSignBlock.f_56987_) * 360) / 16.0f);
            stack.m_85845_(Vector3f.f_122225_.m_122240_(f1));
        } else {
            stack.m_85837_(0.5, 0.5, 0.5);
            float f4 = -((Direction)state.m_61143_((Property)WallSignBlock.f_58064_)).m_122435_();
            stack.m_85845_(Vector3f.f_122225_.m_122240_(f4));
            stack.m_85837_(0.0, -0.3125, -0.4375);
        }
        stack.m_85836_();
        stack.m_85841_(scaleFactor, -scaleFactor, -scaleFactor);
    }

    private void drawText(SignFrameTile tile, PoseStack stack, MultiBufferSource buffer, int combinedOverlay) {
        int newCombinedOverlay;
        boolean flag;
        int textColor;
        stack.m_85849_();
        float scaleFactor = 0.010416667f;
        stack.m_85837_(0.0, 0.3333333432674408, 0.046666666865348816);
        stack.m_85841_(scaleFactor, -scaleFactor, scaleFactor);
        int darkColor = FrameSignRenderer.getDarkColor(tile);
        int j = 20;
        FormattedCharSequence[] formattedCharSequences = tile.m_155717_(Minecraft.m_91087_().m_167974_(), component -> {
            List list = this.font.m_92923_((FormattedText)component, 90);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (tile.m_155727_()) {
            textColor = tile.m_59753_().m_41071_();
            flag = FrameSignRenderer.isOutlineVisible(tile, textColor);
            newCombinedOverlay = 0xF000F0;
        } else {
            textColor = darkColor;
            flag = false;
            newCombinedOverlay = combinedOverlay;
        }
        for (int line = 0; line < 4; ++line) {
            FormattedCharSequence formattedcharsequence = formattedCharSequences[line];
            float f3 = -this.font.m_92724_(formattedcharsequence) / 2;
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f3, (float)(line * 10 - j), textColor, darkColor, stack.m_85850_().m_85861_(), buffer, newCombinedOverlay);
                continue;
            }
            this.font.m_92733_(formattedcharsequence, f3, (float)(line * 10 - j), textColor, false, stack.m_85850_().m_85861_(), buffer, false, 0, newCombinedOverlay);
        }
        stack.m_85849_();
    }

    public static final class FrameSignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart stick;

        public FrameSignModel(ModelPart part) {
            super(RenderType::m_110473_);
            this.root = part;
            this.stick = part.m_171324_(FrameSignRenderer.STICK);
        }

        public void m_7695_(PoseStack p_112510_, VertexConsumer p_112511_, int p_112512_, int p_112513_, float p_112514_, float p_112515_, float p_112516_, float p_112517_) {
            this.root.m_104306_(p_112510_, p_112511_, p_112512_, p_112513_, p_112514_, p_112515_, p_112516_, p_112517_);
        }
    }
}

