/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class SlabFrameBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(TwoBlocksFrameBlockTile.MIMIC_1);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, BakedModel model) {
        if (side == null) {
            return Collections.emptyList();
        }
        BlockState mimic_1 = (BlockState)extraData.get(TwoBlocksFrameBlockTile.MIMIC_1);
        BlockState mimic_2 = (BlockState)extraData.get(TwoBlocksFrameBlockTile.MIMIC_2);
        boolean sameBlocks = mimic_1 != null && mimic_2 != null && mimic_2 != Blocks.f_50016_.m_49966_() ? mimic_1.m_60713_(mimic_2.m_60734_()) : false;
        if (mimic_1 != null && state != null) {
            TextureAtlasSprite texture_1 = TextureHelper.getTexture(model, rand, extraData, TwoBlocksFrameBlockTile.TEXTURE_1);
            TextureAtlasSprite texture_2 = null;
            if (mimic_2 != null && mimic_2 != Blocks.f_50016_.m_49966_()) {
                ModelResourceLocation location_2 = BlockModelShaper.m_110895_((BlockState)mimic_2);
                BakedModel model_2 = Minecraft.m_91087_().m_91304_().m_119422_(location_2);
                texture_2 = TextureHelper.getTexture(model_2, rand, extraData, TwoBlocksFrameBlockTile.TEXTURE_2);
            }
            int tintIndex_1 = BlockAppearanceHelper.setTintIndex(mimic_1);
            int tintIndex_2 = mimic_2 == null ? -1 : BlockAppearanceHelper.setTintIndex(mimic_2);
            boolean renderNorth = side == Direction.NORTH && (Boolean)extraData.get(TwoBlocksFrameBlockTile.NORTH_VISIBLE) != false;
            boolean renderEast = side == Direction.EAST && (Boolean)extraData.get(TwoBlocksFrameBlockTile.EAST_VISIBLE) != false;
            boolean renderSouth = side == Direction.SOUTH && (Boolean)extraData.get(TwoBlocksFrameBlockTile.SOUTH_VISIBLE) != false;
            boolean renderWest = side == Direction.WEST && (Boolean)extraData.get(TwoBlocksFrameBlockTile.WEST_VISIBLE) != false;
            boolean renderUp = side == Direction.UP && (Boolean)extraData.get(TwoBlocksFrameBlockTile.UP_VISIBLE) != false;
            boolean renderDown = side == Direction.DOWN && (Boolean)extraData.get(TwoBlocksFrameBlockTile.DOWN_VISIBLE) != false;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                case UP: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast, renderWest, renderUp && !sameBlocks, renderDown));
                    break;
                }
                case DOWN: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown && !sameBlocks));
                    break;
                }
                case WEST: {
                    quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast, renderWest && !sameBlocks, renderUp, renderDown));
                    break;
                }
                case SOUTH: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, texture_1, tintIndex_1, renderNorth, renderSouth && !sameBlocks, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case NORTH: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, texture_1, tintIndex_1, renderNorth && !sameBlocks, renderSouth, renderEast, renderWest, renderUp, renderDown));
                    break;
                }
                case EAST: {
                    quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, texture_1, tintIndex_1, renderNorth, renderSouth, renderEast && !sameBlocks, renderWest, renderUp, renderDown));
                }
            }
            if (((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue() && texture_2 != null) {
                switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, renderEast, renderWest, renderUp, !sameBlocks));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, renderEast, renderWest, !sameBlocks, renderDown));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, !sameBlocks, renderWest, renderUp, renderDown));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, texture_2, tintIndex_2, !sameBlocks, renderSouth, renderEast, renderWest, renderUp, renderDown));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, texture_2, tintIndex_2, renderNorth, !sameBlocks, renderEast, renderWest, renderUp, renderDown));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture_2, tintIndex_2, renderNorth, renderSouth, renderEast, !sameBlocks, renderUp, renderDown));
                    }
                }
            }
            int overlayIndex_1 = (Integer)extraData.get(TwoBlocksFrameBlockTile.OVERLAY_1);
            if ((Integer)extraData.get(TwoBlocksFrameBlockTile.OVERLAY_1) != 0) {
                switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                    case UP: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, overlayIndex_1, renderNorth, renderSouth, renderEast, renderWest, renderUp && !sameBlocks, renderDown, true));
                        break;
                    }
                    case DOWN: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown && !sameBlocks, true));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderNorth && !sameBlocks, renderSouth, renderEast, renderWest, renderUp && !sameBlocks, renderDown, true));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, overlayIndex_1, renderNorth, renderSouth, renderEast && !sameBlocks, renderWest, renderUp && !sameBlocks, renderDown, true));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, overlayIndex_1, renderNorth, renderSouth, renderEast, renderWest && !sameBlocks, renderUp && !sameBlocks, renderDown, true));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_1, renderNorth, renderSouth && !sameBlocks, renderEast, renderWest, renderUp && !sameBlocks, renderDown, true));
                    }
                }
            }
            if (((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                int overlayIndex_2 = (Integer)extraData.get(TwoBlocksFrameBlockTile.OVERLAY_2);
                if ((Integer)extraData.get(TwoBlocksFrameBlockTile.OVERLAY_2) != 0) {
                    switch ((Direction)state.m_61143_((Property)SixWaySlabFrameBlock.FACING)) {
                        case UP: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, overlayIndex_2, renderNorth, renderSouth, renderEast, renderWest, renderUp, renderDown && !sameBlocks, false));
                            break;
                        }
                        case DOWN: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 1.0f, overlayIndex_2, renderNorth, renderSouth, renderEast, renderWest, renderUp && !sameBlocks, renderDown, false));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_2, renderNorth, renderSouth && !sameBlocks, renderEast, renderWest, renderUp, renderDown, false));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 1.0f, overlayIndex_2, renderNorth, renderSouth, renderEast, renderWest && !sameBlocks, renderUp, renderDown, false));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createOverlay(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, overlayIndex_2, renderNorth, renderSouth, renderEast && !sameBlocks, renderWest, renderUp, renderDown, false));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createOverlay(0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, overlayIndex_2, renderNorth && !sameBlocks, renderSouth, renderEast, renderWest, renderUp, renderDown, false));
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

