/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.world;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.world.BalmWorldGen;
import net.blay09.mods.balm.api.world.BiomePredicate;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.blay09.mods.balm.forge.world.BalmBiomeModifier;
import net.blay09.mods.balm.forge.world.BiomeModification;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ForgeBalmWorldGen
implements BalmWorldGen {
    public static final Codec<BalmBiomeModifier> BALM_BIOME_MODIFIER_CODEC = Codec.unit((Object)BalmBiomeModifier.INSTANCE);
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();
    private static final List<BiomeModification> biomeModifications = new ArrayList<BiomeModification>();

    public ForgeBalmWorldGen() {
        if (FMLJavaModLoadingContext.get() != null) {
            DeferredRegister registry = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"balm");
            registry.register("balm", () -> BALM_BIOME_MODIFIER_CODEC);
            registry.register(FMLJavaModLoadingContext.get().getModEventBus());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public <T extends Feature<?>> DeferredObject<T> registerFeature(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.FEATURES, identifier.m_135827_());
        RegistryObject registryObject = register.register(identifier.m_135815_(), supplier);
        return new DeferredObject(identifier, registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public <FC extends FeatureConfiguration, F extends Feature<FC>, T extends ConfiguredFeature<FC, F>> DeferredObject<T> registerConfiguredFeature(ResourceLocation identifier, Supplier<F> featureSupplier, Supplier<FC> configurationSupplier) {
        DeferredObject<ConfiguredFeature> deferredObject = new DeferredObject<ConfiguredFeature>(identifier, () -> {
            Holder configuredFeature = FeatureUtils.m_206488_((String)identifier.toString(), (Feature)((Feature)featureSupplier.get()), (FeatureConfiguration)((FeatureConfiguration)configurationSupplier.get()));
            return (ConfiguredFeature)configuredFeature.m_203334_();
        });
        this.getActiveRegistrations().configuredFeatures.add(deferredObject);
        return deferredObject;
    }

    @Override
    public <T extends PlacedFeature> DeferredObject<T> registerPlacedFeature(ResourceLocation identifier, Supplier<ConfiguredFeature<?, ?>> configuredFeatureSupplier, PlacementModifier ... placementModifiers) {
        DeferredObject<PlacedFeature> deferredObject = new DeferredObject<PlacedFeature>(identifier, () -> {
            Holder placedFeature = PlacementUtils.m_206513_((String)identifier.toString(), (Holder)Holder.m_205709_((Object)((ConfiguredFeature)configuredFeatureSupplier.get())), (PlacementModifier[])placementModifiers);
            return (PlacedFeature)placedFeature.m_203334_();
        });
        this.getActiveRegistrations().placedFeatures.add(deferredObject);
        return deferredObject;
    }

    @Override
    public <T extends PlacementModifierType<?>> DeferredObject<T> registerPlacementModifier(ResourceLocation identifier, Supplier<T> supplier) {
        DeferredObject<PlacementModifierType> deferredObject = new DeferredObject<PlacementModifierType>(identifier, () -> {
            PlacementModifierType placementModifierType = (PlacementModifierType)supplier.get();
            Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)identifier, (Object)placementModifierType);
            return placementModifierType;
        });
        this.getActiveRegistrations().placementModifiers.add(deferredObject);
        return deferredObject;
    }

    @Override
    public void addFeatureToBiomes(BiomePredicate biomePredicate, GenerationStep.Decoration step, ResourceLocation placedFeatureIdentifier) {
        ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)placedFeatureIdentifier);
        biomeModifications.add(new BiomeModification(biomePredicate, step, (ResourceKey<PlacedFeature>)resourceKey));
    }

    public void modifyBiome(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            for (BiomeModification biomeModification : biomeModifications) {
                ResourceLocation location = biome.m_203543_().map(ResourceKey::m_135782_).orElse(null);
                if (location == null || !biomeModification.getBiomePredicate().test(location, biome)) continue;
                BuiltinRegistries.f_194653_.m_203636_(biomeModification.getConfiguredFeatureKey()).ifPresent(placedFeature -> builder.getGenerationSettings().m_204201_(biomeModification.getStep(), placedFeature));
            }
        }
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final List<DeferredObject<?>> configuredFeatures = new ArrayList();
        public final List<DeferredObject<?>> placedFeatures = new ArrayList();
        public final List<DeferredObject<?>> placementModifiers = new ArrayList();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                this.placementModifiers.forEach(DeferredObject::resolve);
                this.configuredFeatures.forEach(DeferredObject::resolve);
                this.placedFeatures.forEach(DeferredObject::resolve);
            });
        }
    }
}

