/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.hands;

import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import artifacts.common.util.DamageSourceHelper;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import top.theillusivec4.curios.api.SlotContext;

public class PowerGloveItem
extends CurioItem {
    public PowerGloveItem() {
        this.addListener(LivingAttackEvent.class, this::onLivingAttack, (T event) -> DamageSourceHelper.getAttacker(event.getSource()));
    }

    private void onLivingAttack(LivingAttackEvent event, LivingEntity wearer) {
        if (DamageSourceHelper.isMeleeAttack(event.getSource())) {
            this.damageEquippedStacks(wearer);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Multimap result = super.getAttributeModifiers(slotContext, uuid, stack);
        if (!ModConfig.server.isCosmetic(this)) {
            int attackDamageBonus = (Integer)ModConfig.server.powerGlove.attackDamageBonus.get();
            result.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, new ResourceLocation("artifacts", "power_glove_attack_damage").toString(), (double)attackDamageBonus, AttributeModifier.Operation.ADDITION));
        }
        return result;
    }
}

