/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.config.item;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public class ItemConfig {
    private final String itemName;
    public final ForgeConfigSpec.IntValue durability;

    public ItemConfig(ForgeConfigSpec.Builder builder, RegistryObject<?> item, String maxDamageDescription) {
        this(builder, item.getId().m_135815_(), maxDamageDescription);
    }

    public ItemConfig(ForgeConfigSpec.Builder builder, String itemName, String maxDamageDescription) {
        this.itemName = itemName;
        builder.push(itemName);
        this.durability = builder.worldRestart().comment(new String[]{maxDamageDescription, "Setting this to 0 will make this item unbreakable"}).translation("artifacts.config.server.items.durability").defineInRange("durability", 0, 0, Short.MAX_VALUE);
        this.addConfigs(builder);
        builder.pop();
    }

    public void bake() {
    }

    public void addConfigs(ForgeConfigSpec.Builder builder) {
    }

    protected String translate(String value) {
        return String.format("%s.config.server.%s.%s", "artifacts", this.itemName, value);
    }
}

