/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import net.acetheeldritchking.art_of_forging.capabilities.subjugation.PlayerSubjugationProvider;
import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.acetheeldritchking.art_of_forging.effects.potion.PotionEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class SubjugationEffect
extends ChargedAbilityEffect {
    public static final SubjugationEffect instance = new SubjugationEffect();

    public SubjugationEffect() {
        super(20, 0.15, 100, 1.0, EffectGuiStats.subjugationEffect, ChargedAbilityEffect.TargetRequirement.entity, UseAnim.SPEAR, "raised");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(EffectGuiStats.subjugationEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "art_of_forging.effect.subjugation.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterInteger("art_of_forging.effect.subjugation.tooltip", (IStatGetter)effectStatGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack heldStack;
        Item item;
        Entity attackingEntity = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        if (attackingEntity instanceof LivingEntity && (item = (heldStack = (attacker = (LivingEntity)attackingEntity).m_21205_()).m_41720_()) instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            int level = item2.getEffectLevel(heldStack, EffectGuiStats.subjugationEffect);
            int eff = (int)item2.getEffectEfficiency(heldStack, EffectGuiStats.subjugationEffect);
            if (level > 0 && !attacker.f_19853_.m_5776_() && attacker instanceof Player) {
                Player player = (Player)attacker;
                player.getCapability(PlayerSubjugationProvider.PLAYER_SUBJUGATION).ifPresent(subjugation -> {
                    subjugation.addSubjugation(1);
                    if (subjugation.getSubjugation() == 10) {
                        target.m_7292_(new MobEffectInstance((MobEffect)PotionEffects.TARGETED.get(), eff * 20, 0, false, false, true));
                    }
                });
            }
        }
    }

    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        if (!target.f_19853_.m_5776_()) {
            attacker.getCapability(PlayerSubjugationProvider.PLAYER_SUBJUGATION).ifPresent(subjugation -> {
                double attackerX = attacker.m_20185_();
                double attackerY = attacker.m_20227_(0.5);
                double attackerZ = attacker.m_20189_();
                int level = item.getEffectLevel(itemStack, EffectGuiStats.subjugationEffect);
                int eff = (int)item.getEffectEfficiency(itemStack, EffectGuiStats.subjugationEffect);
                if (subjugation.getSubjugation() == 10 && target.m_21023_((MobEffect)PotionEffects.TARGETED.get())) {
                    subjugation.resetSubjugation();
                    AbilityUseResult result = this.performAttack(attacker, item, itemStack, target, eff, level);
                    this.playSounds(attackerX, attackerY, attackerZ, (ServerPlayer)attacker);
                }
            });
        }
        attacker.m_21011_(hand, false);
        attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
        item.tickProgression((LivingEntity)attacker, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private AbilityUseResult performAttack(Player attacker, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, int duration, float damage) {
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 0.0, 0.0f, 0.0f);
        if (result != AbilityUseResult.fail) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration * 20, 1, true, true, true));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, duration * 20, 1, true, true, true));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration * 20, 1, true, true, true));
            target.m_6469_(DamageSource.f_19319_, damage);
            attacker.m_5634_(5.0f);
        }
        return result;
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        ItemStack heldStack = event.player.m_21205_();
        Item item = heldStack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            int level = item2.getEffectLevel(heldStack, EffectGuiStats.subjugationEffect);
            double posX = event.player.m_20185_();
            double posY = event.player.m_20227_(0.5);
            double posZ = event.player.m_20189_();
            if (level >= 2) {
                event.player.getCapability(PlayerSubjugationProvider.PLAYER_SUBJUGATION).ifPresent(subjugation -> {
                    if (subjugation.getSubjugation() >= 10) {
                        ServerLevel world = (ServerLevel)event.player.f_19853_;
                        world.m_8767_((ParticleOptions)ParticleTypes.f_123784_, posX, posY, posZ, 1, 0.1, 0.1, 0.1, 0.0);
                    }
                });
            }
        }
    }

    private void playSounds(double x, double y, double z, ServerPlayer player) {
        player.f_19853_.m_6263_(null, x, y, z, SoundEvents.f_12557_, SoundSource.PLAYERS, 1.0f, 0.5f);
    }
}

