/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.datagen;

import com.google.common.base.Preconditions;
import com.hollingsworth.arsnouveau.api.RegistryHelper;
import de.sarenor.arsinstrumentum.setup.Registration;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemModels
extends ItemModelProvider {
    private static final Logger log = LogManager.getLogger(ItemModels.class);

    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "ars_instrumentum", existingFileHelper);
    }

    protected void registerModels() {
        log.info("ArsInstrumentum: RegisterItemModels started");
        for (RegistryObject item : Registration.ITEMS.getEntries()) {
            if (item == Registration.ARCANE_APPLICATOR_ITEM) continue;
            try {
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(RegistryHelper.getRegistryName((Item)((Item)item.get())).m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.itemTexture((Item)item.get()));
            }
            catch (Exception e) {
                System.out.println("No texture for " + item.toString());
            }
        }
        log.info("ArsInstrumentum: RegisterItemModels ended");
    }

    private ResourceLocation itemTexture(Item item) {
        ResourceLocation name = this.registryName(item);
        return new ResourceLocation(name.m_135827_(), "items/" + name.m_135815_());
    }

    private ResourceLocation registryName(Item item) {
        return (ResourceLocation)Preconditions.checkNotNull((Object)RegistryHelper.getRegistryName((Item)item), (String)"Item %s has a null registry name", (Object)item);
    }
}

